package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import java.util.List;
import java.util.Map;

import org.junit.ClassRule;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Images;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;

public class BsTransportOfNewPicInNewBannerBaseTest {

    private static final String login = Logins.LOGIN_TRANSPORT_IMG_REGULAR;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static final TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    protected static int shard;

    protected static Long pid;
    protected static Long picBid;
    protected static Long syncedBid;
    protected static Long imageId;

    protected static Context context;
    protected static List<Phrase> phrases;
    protected static Banner picBanner;
    protected static Banner syncedBanner;
    protected static Banner pic;
    protected static Images images;
    protected static Images parentBannerImages;
    protected static Map<String, Map> contextMap;

    protected static void prepareAndSendCampaign(boolean inSingleSend) {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, ImageType.REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        syncedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(syncedBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);

        picBid = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                        .withAdGroupId(pid)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()
                                .withAdImageHash(imageHashes[0])));
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(picBid)
                .getImageId();
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, picBid);
        }

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = getMapValues(context != null ? context.getPhrases() : null);
        picBanner = context != null ? context.getBanner(picBid) : null;
        syncedBanner = context != null ? context.getBanner(syncedBid) : null;
        pic = context != null ? context.getBanner(imageId) : null;
        images = pic != null ? pic.getImages() : null;
        parentBannerImages = picBanner != null ? picBanner.getImages() : null;
        contextMap = helpSteps.getContextMap(resp, cid, pid);
    }
}
