package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import java.util.Arrays;
import java.util.Collection;

import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Images;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.matchers.images.BannerRegularImagesMatcher;
import ru.yandex.autotests.directintapi.bstransport.matchers.images.BannerWideImagesMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDoNotSendExtraBannerImageFormatToBsProperty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК картинки - типы и форматы")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfNewPicInNewBannerSizesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_TRANSPORT_IMG_REGULAR);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter
    public String login;

    @Parameterized.Parameter(1)
    public ImageType type;

    @Parameterized.Parameter(2)
    public BaseMatcher<Images> formatMatcher;

    @Parameterized.Parameter(3)
    public boolean inSingleSend;

    private Banner pic;
    private Banner banner;

    @Parameterized.Parameters(name = "{0}, единый баннер = {3}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Logins.LOGIN_TRANSPORT_IMG_REGULAR,
                        ImageType.REGULAR,
                        BannerRegularImagesMatcher.isValid(getDoNotSendExtraBannerImageFormatToBsProperty(api)),
                        false,
                },
                //DIRECT-50792
                {Logins.LOGIN_TRANSPORT_IMG_WIDE,
                        ImageType.WIDE,
                        BannerWideImagesMatcher.isValid(),
                        false,
                },
                {Logins.LOGIN_TRANSPORT_IMG_REGULAR,
                        ImageType.REGULAR,
                        BannerRegularImagesMatcher.isValid(getDoNotSendExtraBannerImageFormatToBsProperty(api)),
                        true,
                },
                {Logins.LOGIN_TRANSPORT_IMG_WIDE,
                        ImageType.WIDE,
                        BannerWideImagesMatcher.isValid(),
                        true,
                },
        };
        return Arrays.asList(data);
    }

    @Before
    public void prepare() {
        api.as(login);
        TransportHelpSteps helpSteps = new TransportHelpSteps(api);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, type);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long syncedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long picBid = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                        .withAdGroupId(pid)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()
                                .withAdImageHash(imageHashes[0])));
        Long imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps()
                .getBannerImagesByBid(picBid)
                .getImageId();
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, picBid);
        }

        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(syncedBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        pic = context != null ? context.getBanner(imageId) : null;
        banner = context != null ? context.getBanner(picBid) : null;
        if (inSingleSend) {
            assumeThat("в БК не отправилась картиночная версия баннера",
                    pic, CoreMatchers.nullValue());
        }
    }

    @Test
    public void testTransportOfImageType() {
        String imageType = inSingleSend ? banner.getImageType() : pic.getImageType();
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                imageType, beanEquals(type.getName()));
    }

    @Test
    public void testTransportOfImageFormats() {
        Images Images = inSingleSend ? banner.getImages() : pic.getImages();
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                Images, formatMatcher);
    }
}
