package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import java.util.Map;

import org.hamcrest.Matcher;
import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.matchers.images.BannerRegularImagesMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDoNotSendExtraBannerImageFormatToBsProperty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК новой картинки " +
        "в новом баннере (1 запрос)")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPicInNewBannerTest extends BsTransportOfNewPicInNewBannerBaseTest {

    @BeforeClass
    public static void beforeClass() {
        prepareAndSendCampaign(false);
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (1 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq1ForNewPicInNewBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (1 запрос) - " +
            "проверка списка Фраз")
    public void testTransportOfPhraseListReq1ForNewPicInNewBanner() {
        assertThat("в БК отправлен не пустой список фраз", phrases, not(empty()));
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (1 запрос) - " +
            "проверка объекта Баннер (новый)")
    public void testTransportOfNewBannerObjReq1ForNewPicInNewBanner() {
        Banner expectedPicBanner = helpSteps.buildExpectedNewBannerObjFromDb(picBid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                picBanner, beanEquals(expectedPicBanner));
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (1 запрос) - " +
            "проверка объекта Баннер (синхронизированный)")
    public void testTransportOfSyncedBannerObjReq1ForNewPicInNewBanner() {
        Banner expectedSyncedBanner = helpSteps.buildExpectedBannerObjFromDb(syncedBid, shard, UpdateInfo.SKIP);
        expectedSyncedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные остановленного баннера соответствуют ожидаемым",
                syncedBanner, beanEquals(expectedSyncedBanner));
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (1 запрос) - " +
            "проверка объекта Картинка (новая в новом баннере)")
    public void testTransportOfNewPicObjReq1ForNewPicInNewBanner() {
        Matcher<Banner> picMatcher =
                helpSteps.buildNewPicBannerMatcherFromDbWithBannerId(imageId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой картинки соответствуют ожидаемым",
                pic, picMatcher);
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (1 запрос) - " +
            "проверка форматов картинок")
    public void testTransportOfImagesObjReq1ForNewPicInNewBanner() {
        BannerRegularImagesMatcher imagesMatcher =
                BannerRegularImagesMatcher.isValid(getDoNotSendExtraBannerImageFormatToBsProperty(api));
        assertThat("отправленные в БК форматы картинок соответствуют ожидаемым", images, imagesMatcher);
    }

    @Test
    @Title("Не-отправка в БК поля Picture новой картинки в новом баннере")
    public void testTransportOfPictureObjReq1ForNewPicInNewBanner() {
        Map<String, Map> imageBanner = (Map<String, Map>) contextMap.get(Context.BANNERS)
                .get(Long.toString(imageId));
        assumeThat("картиночный баннер отправлен в БК", imageBanner, not(nullValue()));
        assertThat("поле " + Banner.PICTURE + "не отправлено в БК"
                , imageBanner.containsKey(Banner.PICTURE), equalTo(false));
    }

    @Test
    @Title("Не-отправка в БК поля PictureMD5 новой картинки в новом баннере")
    public void testTransportOfPictureMD5ObjReq1ForNewPicInNewBanner() {

        Map<String, Map> imageBanner = (Map<String, Map>) contextMap.get(Context.BANNERS)
                .get(Long.toString(imageId));
        assumeThat("картиночный баннер отправлен в БК", imageBanner, not(nullValue()));
        assertThat("поле " + Banner.PICTURE_MD5 + "не отправлено в БК"
                , imageBanner.containsKey(Banner.PICTURE_MD5), equalTo(false));
    }
}
