package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 08/02/16.
 * https://st.yandex-team.ru/TESTIRT-8458
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-50792")
@Title("Транспорт: проверка отправки в БК картинки - тип wide")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPicInNewBannerWideTest extends BsTransportOfNewPicInNewBannerWideBaseTest {

    @BeforeClass
    public static void prepare() {
        prepareAndSendCampaign(false);
    }

    @Test
    public void testTransportOfWideImageType() {
        assertThat("в БК отправилась картинка с форматом wide",
                pic, notNullValue());
    }

    @Test
    public void testTransportOfTextPartOfBannerWithWideImageType() {
        assertThat("в БК отправилась текстовая часть баннера",
                picBanner, notNullValue());
    }
}
