package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import org.assertj.core.api.SoftAssertions;
import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-171884")
@Title("Транспорт: проверка отправки в БК картинки - тип wide, в едином баннере")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPicInNewBannerWideWithSingleSendTest extends BsTransportOfNewPicInNewBannerWideBaseTest {

    @BeforeClass
    public static void prepare() {
        prepareAndSendCampaign(true);
    }

    @Test
    public void testTransportOfWideImageType() {
        SoftAssertions soft = new SoftAssertions();
        soft.assertThat(picBanner)
                .as("баннер отправился в БК")
                .isNotNull();
        soft.assertThat(picBanner.getImages())
                .as("у баннера есть Images")
                .isNotNull();
        soft.assertThat(picBanner.getResources().getAutoVideoCreative())
                .as("у баннера есть AutoVideoCreative")
                .isNotNull();
        soft.assertThat(picBanner.getIsAutoVideo())
                .as("у баннера есть IsAutoVideo")
                .isEqualTo(1);
        soft.assertThat(picBanner.getImageType())
                .as("у баннера есть ImageType")
                .isNotNull();
        soft.assertThat(pic)
                .as("картиночная версия баннера не отправилась в БК")
                .isNull();
        soft.assertAll();
    }

    @Test
    public void testTransportOfTextPartOfBannerWithWideImageType() {
        assertThat("в БК отправилась текстовая часть баннера",
                picBanner, notNullValue());
    }
}
