package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsResyncQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 03.12.15.
 * https://st.yandex-team.ru/TESTIRT-7719
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-48743")
@RunWith(Parameterized.class)
public class BsTransportOfNewPicInNewStoppedAndResumedBannerTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private Long pid;
    private Long bid;
    private Long cid;

    @Parameterized.Parameter
    public boolean inSingleSend;

    @Parameterized.Parameters(name = "Единый баннер = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {false},
                {true},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
    }

    @Before
    public void prepare() {
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, REGULAR);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);

        api.userSteps.adsSteps().adsSuspend(bid);

        api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);

        api.userSteps.adsSteps()
                .adsUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(bid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withAdImageHash(imageHashes[0]))));
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerateByBid(bid, BannerImagesStatusmoderate.Yes);
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, bid);
        }

        api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);

        api.userSteps.adsSteps().adsResume(bid);

        api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);
    }

    @Test
    public void testTransportOfStoppedAndResumedBannerAfterImageAdded() {
        BsResyncQueueRecord actual = api.userSteps.getDirectJooqDbSteps()
                .bsResyncQueueSteps()
                .getBsResyncQueueRecord(cid, pid, bid);
        assertThat("в таблице ppc.bs_resync_queue присутствует запись для " +
                        "заархивированного баннера с отключенным доменом",
                actual, notNullValue());
    }
}
