package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка не-отправки в БК новой картинки " +
        "в остановленном баннере (1 запрос)")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPicInSyncedStoppedBannerTest extends BsTransportOfNewPicInSyncedStoppedBannerBaseTest {

    @BeforeClass
    public static void beforeClass() {
        prepareAndSendCampaign(false);
    }

    @Test
    @Title("Не-отправка в БК новой картинки в остановленном баннере (1 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq1ForNewPicInStoppedBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в остановленном баннере (1 запрос) - " +
            "проверка объекта Баннер (новый)")
    public void testTransportOfNewBannerObjReq1ForNewPicInStoppedBanner() {
        Banner expectedNewBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedNewBanner));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в остановленном баннере (1 запрос) - " +
            "проверка объекта Баннер (остановленный)")
    public void testTransportOfStoppedBannerObjReq1ForNewPicInStoppedBanner() {
        Banner expectedStoppedBanner = helpSteps.buildExpectedBannerObjFromDb(stoppedBid, shard, UpdateInfo.SKIP);
        expectedStoppedBanner.setStop(StopFlag.STOP.value());
        assertThat("отправленные в БК данные остановленного баннера соответствуют ожидаемым",
                stoppedBanner, beanEquals(expectedStoppedBanner));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в остановленном баннере (1 запрос) - " +
            "проверка объекта Картинка (в остановленном баннере)")
    public void testTransportOfStoppedImageBannerObjReq1ForNewPicInStoppedBanner() {
        assertThat("в БК не отправлена новая картинка в остановленном баннере",
                stoppedImageBanner, nullValue());
    }
}
