package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.beanutils.BeanMap;
import org.assertj.core.api.SoftAssertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesFormatsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Images;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.images.AdImageMap;
import ru.yandex.autotests.directapi.model.images.AdImageRawMap;
import ru.yandex.autotests.directapi.model.images.AdImageRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.utils.ImageBase64Utils;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by buhter on 25.02.16.
 * https://st.yandex-team.ru/TESTIRT-8614
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-51310")
@Title("Отправка картинки, у которой нет описания форматов")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfPicNoFormatsTest {

    private static final String login = Logins.LOGIN_TRANSPORT_IMG_NO_FORMATS;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private Long cid;
    private Long imageId;
    private Long pid;
    private Long bid;
    private String adImageHash;

    @Parameterized.Parameter
    public boolean inSingleSend;

    @Parameterized.Parameters(name = "Единый баннер = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {false},
                {true},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        AdImageRawMap adImageRawMap = new AdImageRawMap(api.type())
                .withLogin(login)
                .withRawData(ImageBase64Utils
                        .getBase64EncodedFileData("https://direct-qa.s3.mds.yandex.net/images/450x450.jpg"))
                .withName("No formats");
        Object response = api.userSteps.imagesSteps().adImage(
                new AdImageRequestMap(api.type())
                        .uploadRawData(adImageRawMap));
        Object adImage = ((Object[]) new BeanMap(response).get("actionsResult"))[0];
        adImageHash = (String) new BeanMap(adImage).get(AdImageMap.AD_IMAGE_HASH);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                        .withAdGroupId(pid)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()
                                .withAdImageHash(adImageHash)));
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(bid)
                .getImageId();
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, bid);
        }

        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    @Title("Отправка в БК картинки без форматов")
    public void testTransportPictureWithoutFormats() {
        BannerImagesFormatsRecord bannerImagesFormats = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesFormatsRecords(adImageHash);

        bannerImagesFormats.setFormats("");
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .updateBannerImagesFormatsRecord(bannerImagesFormats);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner picBanner = context != null ? context.getBanner(bid) : null;
        Banner pic = context != null ? context.getBanner(imageId) : null;
        checkBanners(picBanner, pic);
    }

    @Test
    @Title("Отправка в БК картинки с пустыми форматами")
    public void testTransportPictureWithEmptyFormats() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .deleteBannerImagesFormatsRecord(adImageHash);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner picBanner = context != null ? context.getBanner(bid) : null;
        Banner pic = context != null ? context.getBanner(imageId) : null;
        checkBanners(picBanner, pic);
    }

    private void checkBanners(Banner picBanner, Banner pic) {
        SoftAssertions soft = new SoftAssertions();
        if (inSingleSend) {
            soft.assertThat(picBanner)
                    .as("баннер отправился в БК")
                    .isNotNull();
            soft.assertThat(picBanner.getResources().getAutoVideoCreative()).
                    as("у баннера есть AutoVideoCreative")
                    .isNotNull();
            soft.assertThat(picBanner.getIsAutoVideo())
                    .as("у баннера есть IsAutoVideo")
                    .isEqualTo(1);
            soft.assertThat(picBanner.getImageType())
                    .as("у баннера нет ImageType")
                    .isNull();
            soft.assertThat(picBanner.getImages())
                    .as("images поле не отправлено в БК")
                    .isEqualToComparingFieldByField(new Images());
            soft.assertThat(pic)
                    .as("картиночная версия баннера не отправилась в БК")
                    .isNull();
        } else {
            soft.assertThat(pic)
                    .as("картиночный баннер отправлен в БК")
                    .isNotNull();
            soft.assertThat(pic.getImageType())
                    .as("у баннера нет ImageType")
                    .isNull();
            soft.assertThat(pic.getImages())
                    .as("images поле не отправлено в БК")
                    .isEqualToComparingFieldByField(new Images());
        }
        soft.assertAll();
    }

    @After
    public void deleteAdImage() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .deleteBannerImagesFormatsRecord(adImageHash);
    }
}
