package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;

import com.google.gson.Gson;
import org.apache.commons.beanutils.BeanUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesFormatsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ImageSizeDescription;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ImageSizeDescriptions;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.MdsMeta;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.SmartCenter;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.SmartCenters;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by adubinkin on 04.04.19.
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-93860")
@Title("Отправка картинки с пользовательским переопределением mds_meta")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfPicWithMdsMetaUserOverrideTest {

    private static final String login = Logins.LOGIN_TRANSPORT_IMG_REGULAR;
    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(login);
    private static final SmartCenters BASE_X80_SMART_CENTERS = new SmartCenters()
            .withForRatio1x1(
                    new SmartCenter()
                            .withX(11)
                            .withY(22)
                            .withW(33)
                            .withH(44))
            .withForRatio3x4(
                    new SmartCenter()
                            .withX(20)
                            .withY(31)
                            .withH(53)
            ).withForRatio16x5(
                    new SmartCenter()
                            .withX(620)
                            .withY(631)
                            .withW(642)
                            .withH(653)
            );
    private static final SmartCenters USER_DEFINED_X80_SMART_CENTERS = new SmartCenters()
            .withForRatio1x1(
                    new SmartCenter()
                            .withX(77)
                            .withH(88))
            .withForRatio3x4(
                    new SmartCenter()
                            .withX(20)
                            .withY(31)
                            .withW(88)
                            .withH(53)
            ).withForRatio16x9(
                    new SmartCenter()
                            .withX(123)
                            .withY(321)
                            .withW(213)
                            .withH(432)
            );
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private Long cid;
    private Long imageId;
    private Long pid;
    private Long picBid;
    private String adImageHash;
    private DirectJooqDbSteps dbSteps;

    @Parameterized.Parameter
    public boolean inSingleSend;

    @Parameterized.Parameters(name = "Единый баннер = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {false},
                {true},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        api.as(login);
        TransportHelpSteps helpSteps = new TransportHelpSteps(api);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, ImageType.REGULAR);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long syncedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        picBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdImageHash(imageHashes[0])));
        BannerImagesRecord imagesRecord = dbSteps.
                imagesSteps().getBannerImagesByBid(picBid);
        imageId = imagesRecord.getImageId();
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, picBid);
        }

        adImageHash = imagesRecord.getImageHash();
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(syncedBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    @Title("Отправка в БК в MdsMeta объедиения mds_meta и user_defined_mds_meta")
    public void testTransportImageuserDefinedMetaMerging() throws InvocationTargetException, IllegalAccessException {
        BannerImagesFormatsRecord bannerImagesFormats = dbSteps.imagesSteps()
                .getBannerImagesFormatsRecords(adImageHash);

        //Получаем из базы mds_meta для привязанной к баннеру картинки
        MdsMeta imageMeta = new Gson().fromJson(bannerImagesFormats.getMdsMeta(), MdsMeta.class);
        if (imageMeta == null) {
            //Если в базе ее нет - создаем пустую
            imageMeta = new MdsMeta();
        }
        if (imageMeta.getImageSizeDescriptions() == null
                || imageMeta.getImageSizeDescriptions().getX80() == null) {
            //Если в mds_meta нет описания нужного формата (x80) - создадим пустое описание
            imageMeta.setImageSizeDescriptions(
                    new ImageSizeDescriptions()
                            .withX80(new ImageSizeDescription()));
        }
        //Устанавливаем эталонное заначение описания смарт-центров в mds_meta и сохраняем в базу
        imageMeta.getImageSizeDescriptions().getX80().setKnownSmartCenters(BASE_X80_SMART_CENTERS);
        bannerImagesFormats.setMdsMeta(new Gson().toJson(imageMeta));

        //Формируем и сохраняем в базу эталонное значение mds_meta_user_override
        MdsMeta userDefinedMeta = new MdsMeta()
                .withImageSizeDescriptions(new ImageSizeDescriptions()
                        .withX80(new ImageSizeDescription()
                                .withKnownSmartCenters(USER_DEFINED_X80_SMART_CENTERS))
                );

        dbSteps.imagesSteps().updateBannerImagesFormatsRecord(bannerImagesFormats);
        dbSteps.imagesSteps().setImageMdsMetaUserOverride(
                dbSteps.usersSteps().getUser(login).getClientid(),
                adImageHash,
                new Gson().toJson(userDefinedMeta));

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);

        MdsMeta expectedMeta = getExpectedMeta(imageMeta, userDefinedMeta);


        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaignWithMdsMeta(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner pic = context != null ? context.getBanner(imageId) : null;
        Banner picBanner = context != null ? context.getBanner(picBid) : null;

        if (inSingleSend) {
            assumeThat("картиночный баннер не отправлен в БК", pic, nullValue());
            MdsMeta mdsMeta = picBanner != null ? picBanner.getMdsMeta() : null;
            assertThat("в MdsMeta получено объединение mds_meta и user_defined_mds_meta",
                    mdsMeta, beanDiffer(expectedMeta));
        } else {
            assumeThat("картиночный баннер отправлен в БК", pic, not(nullValue()));
            MdsMeta mdsMeta = pic != null ? pic.getMdsMeta() : null;
            assertThat("в MdsMeta получено объединение mds_meta и user_defined_mds_meta",
                    mdsMeta, beanDiffer(expectedMeta));
        }
    }

    private MdsMeta getExpectedMeta(MdsMeta baseMeta, MdsMeta userMeta)
            throws java.lang.IllegalAccessException, java.lang.reflect.InvocationTargetException {
        MdsMeta expectedMeta = new MdsMeta();
        BeanUtils.copyProperties(expectedMeta, baseMeta);

        //copyProperties копирует и null значения из destination, поэтому просто выставим те значения, которые должны
        // измениться
        SmartCenters expectedSmartCenters = expectedMeta.getImageSizeDescriptions().getX80().getKnownSmartCenters();
        SmartCenters userSmartCenters = userMeta.getImageSizeDescriptions().getX80().getKnownSmartCenters();
        expectedSmartCenters.setForRatio16x9(userSmartCenters.getForRatio16x9());
        expectedSmartCenters.getForRatio3x4().setW(userSmartCenters.getForRatio3x4().getW());
        expectedSmartCenters.getForRatio1x1().setX(userSmartCenters.getForRatio1x1().getX());
        expectedSmartCenters.getForRatio1x1().setH(userSmartCenters.getForRatio1x1().getH());

        return expectedMeta;
    }

}
