package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req2;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК новой картинки " +
        "в новом баннере (2 запрос)")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPicInNewBannerTest extends BsTransportOfNewPicInNewBannerBaseTest {

    @BeforeClass
    public static void beforeClass() {
        prepareAndSendCampaign(false);
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (2 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq2ForNewPicInNewBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                contextReq2, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (2 запрос) - " +
            "проверка списка Фраз")
    public void testTransportOfPhraseListReq2ForNewPicInNewBanner() {
        assertThat("в БК не отправлены фразы", phrasesReq2, nullValue());
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (2 запрос) - " +
            "проверка объекта Баннер (новый)")
    public void testTransportOfNewBannerObjReq2ForNewPicInNewBanner() {
        String bannerId = picBannerResp1.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Banner expectedPicBanner = helpSteps.buildExpectedBannerObjFromDb(picBid, shard, UpdateInfo.SKIP);
        expectedPicBanner.setId(bannerId);
        expectedPicBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                picBannerReq2, beanEquals(expectedPicBanner));
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (2 запрос) - " +
            "проверка объекта Баннер (синхронизированный)")
    public void testTransportOfSyncedBannerObjReq2ForNewPicInNewBanner() {
        assertThat("в БК не отправлен синхронизированный баннер",
                syncedBannerReq2, nullValue());
    }

    @Test
    @Title("Отправка в БК новой картинки в новом баннере (2 запрос) - " +
            "проверка объекта Картинка (новая в новом баннере)")
    public void testTransportOfNewPicObjReq2ForNewPicInNewBanner() {
        String bannerId = picResp1.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Banner expectedPicBanner = helpSteps.buildExpectedPicBannerObjFromDb(imageId, shard, UpdateInfo.SKIP);
        expectedPicBanner.setId(bannerId);
        expectedPicBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные новой картинки соответствуют ожидаемым",
                picReq2, beanEquals(expectedPicBanner));
    }
}
