package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req2;

import java.util.Collection;

import org.junit.ClassRule;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;

public class BsTransportOfNewPicInSyncedBannerBaseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static final TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    protected static int shard;

    protected static Long pid;
    protected static Long imageId;
    protected static Long picBid;

    protected static Banner picResp1;

    protected static Context contextReq2;
    protected static Collection<Phrase> phrasesReq2;
    protected static Banner picBannerReq2;
    protected static Banner picBannerReq1;
    protected static Banner picReq2;

    protected static void prepareAndSendCampaign(boolean inSingleSend) {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        picBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.adsSteps()
                .adsUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(picBid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withAdImageHash(imageHashes[0]))));
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(picBid)
                .getImageId();
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, picBid);
        }
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerateByBid(picBid, BannerImagesStatusmoderate.Yes);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);

        Campaign campaignReq1 = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        Context contextReq1 = campaignReq1 != null ? campaignReq1.getContext(pid) : null;
        picBannerReq1 = contextReq1 != null ? contextReq1.getBanner(picBid) : null;

        Campaign campaignResp1 = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataResponseCampaign(resp, 0, cid);
        Context contextResp1 = campaignResp1 != null ? campaignResp1.getContext(pid) : null;
        picResp1 = contextResp1 != null ? contextResp1.getBanner(imageId) : null;

        Campaign campaignReq2 = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 1, cid);
        contextReq2 = campaignReq2 != null ? campaignReq2.getContext(pid) : null;
        phrasesReq2 = contextReq2 != null &&
                contextReq2.getPhrases() != null &&
                contextReq2.getPhrases().values().size() > 0 ?
                contextReq2.getPhrases().values() : null;
        picBannerReq2 = contextReq2 != null ? contextReq2.getBanner(picBid) : null;
        picReq2 = contextReq2 != null ? contextReq2.getBanner(imageId) : null;
    }
}
