package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req2;

import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Добавление картинки к синхронизированному баннеру")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPicInSyncedBannerTest extends BsTransportOfNewPicInSyncedBannerBaseTest {

    @BeforeClass
    public static void beforeClass() {
        prepareAndSendCampaign(false);
    }

    @Test
    @Title("Отправка в БК новой картинки в синхронизированном баннере (2 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq2ForNewPicInSyncedBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                contextReq2, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой картинки в синхронизированном баннере (2 запрос) - " +
            "проверка списка Фраз")
    public void testTransportOfPhraseListReq2ForNewPicInSyncedBanner() {
        assertThat("в БК не отправлены фразы", phrasesReq2, nullValue());
    }

    @Test
    @Title("Отправка в БК новой картинки в синхронизированном баннере (2 запрос) - " +
            "проверка объекта Баннер (синхронизированный)")
    public void testTransportOfSyncedBannerObjReq2ForNewPicInSyncedBanner() {
        assertThat("в БК не отправлен синхронизированный баннер", picBannerReq2, nullValue());
    }

    @Test
    @Title("Отправка в БК новой картинки в синхронизированном баннере (2 запрос) - " +
            "проверка объекта Картинка (новая в синхронизированном баннере)")
    public void testTransportOfNewPicObjReq2ForNewPicInSyncedBanner() {
        String bannerId = picResp1.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Banner expectedPicBanner = helpSteps.buildExpectedPicBannerObjFromDb(imageId, shard, UpdateInfo.SKIP);
        expectedPicBanner.setId(bannerId);
        expectedPicBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные новой картинки соответствуют ожидаемым",
                picReq2, beanEquals(expectedPicBanner));
    }
}
