package ru.yandex.autotests.directintapi.bstransport.main.image.actions.deletion;

import org.assertj.core.api.SoftAssertions;
import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК удаленной картинки, в едином баннере")
@Stories(StoriesNames.IMAGE_ACTION_DELETION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfDeletedPicWithSingleSend extends BsTransportOfDeletedPicBase {

    @BeforeClass
    public static void beforeClass() {
        prepareAndSendCampaign(true);
    }

    @Test
    @Title("Отправка в БК удаленной картинки (1 запрос) - проверка объекта Контекст")
    public void testTransportOfContextObjForDeletedPic() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК удаленной картинки (1 запрос) - проверка списка Фраз")
    public void testTransportOfPhraseListForDeletedPic() {
        assertThat("в БК отправлен не пустой список фраз", phrases, not(empty()));
    }

    @Test
    @Title("Отправка в БК удаленной картинки (1 запрос) - проверка объекта Баннер")
    public void testTransportOfBannerObjForDeletedPic() {
        Banner expectedPicBanner = helpSteps.buildExpectedBannerObjFromDb(picBid, shard, UpdateInfo.UPDATE);
        expectedPicBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные баннера соответствуют ожидаемым",
                picBanner, beanEquals(expectedPicBanner));
    }

    @Test
    @Title("Отправка в БК удаленной картинки (1 запрос) - проверка объекта Картинка (удаленная)")
    public void testTransportOfPicObjForDeletedPic() {
        SoftAssertions soft = new SoftAssertions();
        soft.assertThat(picBanner.getImages())
                .as("у баннера нет Images")
                .isNull();
        soft.assertThat(picBanner.getResources().getAutoVideoCreative()).
                as("у баннера нет AutoVideoCreative")
                .isNull();
        soft.assertThat(picBanner.getIsAutoVideo())
                .as("у баннера нет IsAutoVideo")
                .isNull();
        soft.assertThat(picBanner.getImageType())
                .as("у баннера нет ImageType")
                .isNull();
        soft.assertThat(pic)
                .as("картиночная версия баннера не отправилась в БК")
                .isNull();
        soft.assertAll();
    }
}
