package ru.yandex.autotests.directintapi.bstransport.main.image.actions.editing.image;

import java.util.List;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.ClassRule;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;

public class BsTransportOfPicInEditedBannerBaseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    protected static int shard;

    protected static Long pid;
    protected static Long picBid;
    protected static Long imageId;

    protected static Context context;
    protected static List<Phrase> phrases;
    protected static Banner picBanner;
    protected static Banner pic;

    protected static void prepareAndSendCampaign(boolean inSingleSend) {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        picBid = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                        .withAdGroupId(pid)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()
                                .withAdImageHash(imageHashes[0])));
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(picBid)
                .getImageId();
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, picBid);
        }
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        api.userSteps.phrasesFakeSteps()
                .makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);

        api.userSteps.adsSteps()
                .adsUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(picBid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withText(RandomStringUtils.randomAlphabetic(15)))));
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);//DIRECT-51859

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = getMapValues(context != null ? context.getPhrases() : null);
        picBanner = context != null ? context.getBanner(picBid) : null;
        pic = context != null ? context.getBanner(imageId) : null;
    }
}
