package ru.yandex.autotests.directintapi.bstransport.main.image.actions.editing.image;

import org.hamcrest.Matcher;
import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК картинки для отредактированного баннера")
@Stories(StoriesNames.IMAGE_ACTION_EDITING)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfPicInEditedBannerTest extends BsTransportOfPicInEditedBannerBaseTest {

    @BeforeClass
    public static void beforeClass() {
        prepareAndSendCampaign(false);
    }

    @Test
    @Title("Отправка в БК картинки для отредактированного баннера (1 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq1ForPicInEditedBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК картинки для отредактированного баннера (1 запрос) - " +
            "проверка списка Фраз")
    public void testTransportOfPhraseListReq1ForPicInEditedBanner() {
        assertThat("в БК отправлен не пустой список фраз", phrases, not(empty()));
    }

    @Test
    @Title("Отправка в БК картинки для отредактированного баннера (1 запрос) - " +
            "проверка объекта Баннер (отредактированный)")
    public void testTransportOfPicBannerObjReq1ForPicInEditedBanner() {
        Banner expectedPicBanner = helpSteps.buildExpectedBannerObjFromDb(picBid, shard, UpdateInfo.UPDATE);
        expectedPicBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные отредактированного баннера соответствуют ожидаемым",
                picBanner, beanEquals(expectedPicBanner));
    }

    @Test
    @Title("Отправка в БК картинки для отредактированного баннера (1 запрос) - " +
            "проверка объекта Картинка (привязанная к отредактированному баннеру)")
    public void testTransportOfPicObjReq1ForPicInEditedBanner() {
        Matcher<Banner> picMatcher =
                helpSteps.buildPicBannerMatcherFromDb(imageId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные картинки соответствуют ожидаемым", pic, picMatcher);
    }
}
