package ru.yandex.autotests.directintapi.bstransport.main.image.parameters;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.tags.BsTransportParameters;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.Tags;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.directapi.darkside.steps.TransportSteps.getBsClientDataBanner;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pashkus on 23/01/17.
 * https://st.yandex-team.ru/TESTIRT-10837
 */

@Aqua.Test
@Tags({
        @Tag(TagDictionary.TRUNK),
        @Tag(TagDictionary.RELEASE),
        @Tag(BsTransportParameters.TemplateID)
})
@Title("Проверяем отправку TemplateID в баннере c картинкой")
@Description("Создаем в одной группе баннеры для шаблонов 320,410")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class TestOfTemplateIDInPicBannerCreation extends TestOfTemplateIDInPicBannerCreationBase {

    @BeforeClass
    public static void beforeClass() {
        prepareAndSendCampaign(false);
    }

    @Test
    @Title("1я итерация: проверяем отправку TemplateID для родительского баннера")
    public void testParentBannerTemplateId320InReq1() {
        Banner banner = getBsClientDataBanner(campaignReq1, pid, picBid);
        assertThat("TemplateID баннера соотв. ожиданиям",
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID.value()));
    }

    @Test
    @Title("1я итерация: проверяем отправку TemplateID для баннера с картинкой")
    public void testPicBannerTemplateId320InReq1() {
        Banner banner = getBsClientDataBanner(campaignReq1, pid, imageId);
        assertThat("TemplateID баннера соотв. ожиданиям",
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID.value()));
    }

    @Test
    @Title("1я итерация: проверяем отправку TemplateID для родительского баннера с визиткой")
    public void testParentBannerTemplateId410InReq1() {
        Banner banner = getBsClientDataBanner(campaignReq1, pid, picBidWithContactInfo);
        assertThat("TemplateID баннера соотв. ожиданиям",
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID_NEW.value()));
    }

    @Test
    @Title("1я итерация: проверяем отправку TemplateID для баннера с картинкой и визиткой")
    public void testPicBannerTemplateId410InReq1() {
        Banner banner = getBsClientDataBanner(campaignReq1, pid, imageIdWithContactInfo);
        assertThat("TemplateID баннера соотв. ожиданиям",
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID_NEW.value()));
    }

    @Test
    @Title("2я итерация: проверяем неотправку TemplateID для родительского баннера")
    public void testParentBannerTemplateIdInReq2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getRawClientDataLogRequestForBanner(bsTransportScriptResponse, cid, pid, picBid, 1);
        assertThat("ключ TemplateID отсутсвует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }

    @Test
    @Title("2я итерация: проверяем неотправку TemplateID для картиночного баннера")
    public void testImageBannerTemplateIdInReq2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getRawClientDataLogRequestForBanner(bsTransportScriptResponse, cid, pid, imageId, 1);
        assertThat("ключ TemplateID отсутсвует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }
}
