package ru.yandex.autotests.directintapi.bstransport.main.imagead.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesFormatsImageType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 16/06/16.
 * https://st.yandex-team.ru/TESTIRT-9352
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "нового графического баннера в новой группе")
@Stories(StoriesNames.IMAGE_AD_BANNER_ACTION_CREATION)
@Features({FeatureNames.IMAGE_ADS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-54196")
@RunWith(Parameterized.class)
public class BsTransportNewImageAdAddToQueueTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private Long cid;
    private Long bid;
    private Long pid;

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameters(name = "Тип кампаниии: {0}, тип группы: {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT}
        };
        return Arrays.asList(data);
    }


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, adGroupType);
        String imageHash = api.userSteps.imagesStepsV5().adImagesGetAllHashes(LOGIN).get(0);
        assumeThat("выбрана картинка правильного формата", api.userSteps.getDirectJooqDbSteps().useShard(shard)
                        .imagesSteps().getBannerImagesFormatsRecords(imageHash).getImageType(),
                equalTo(BannerImagesFormatsImageType.image_ad));
        bid = api.userSteps.adsSteps().addAdWithAdImageHash(pid, adGroupType, BannerType.IMAGE_AD, imageHash);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setImageStatusModerate(bid, imageHash, ImagesStatusmoderate.Yes);

    }

    @Test
    @Title("Добавление в очередь нового графического баннера в новой группе")
    public void testAddingToBsQueue() {
        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());

        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, notNullValue());

        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, bid);
        assertThat("Ожидаем, что в БК может быть отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Добавление в очередь 2 новых графических баннеров в новой группе")
    public void testAddingTwoToBsQueue() {
        String imageHash = api.userSteps.imagesStepsV5().adImagesGetAllHashes(LOGIN).get(1);
        Long secondBid = api.userSteps.adsSteps().addAdWithAdImageHash(pid, adGroupType, BannerType.IMAGE_AD,
                imageHash);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(secondBid);
        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setImageStatusModerate(secondBid, imageHash, ImagesStatusmoderate.Yes);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());

        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, notNullValue());

        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, bid);
        assertThat("Ожидаем, что в БК может быть отправлен баннер", banner, notNullValue());

        Map secondBanner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid,
                secondBid);
        assertThat("Ожидаем, что в БК может быть отправлен баннер", secondBanner, notNullValue());
    }
}

