package ru.yandex.autotests.directintapi.bstransport.main.imagead.queue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesFormatsImageType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesFormatsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.hamcrest.Matchers.iterableWithSize;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 16/06/16.
 * https://st.yandex-team.ru/TESTIRT-9352
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "нового графического баннера в новой группе с картиночным баннером ")
@Stories(StoriesNames.IMAGE_AD_BANNER_ACTION_CREATION)
@Features({FeatureNames.IMAGE_ADS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-54196")
@RunWith(Parameterized.class)
public class BsTransportNewImageAdWithOldImageBannersInGroupAddToQueueTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD_WITH_OLD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private Long cid;
    private Long pid;
    private Long picBid;
    private Long graphicBid;

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameters(name = "Тип кампаниии: {0}, тип группы: {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        List<String> imageHashes = api.userSteps.imagesStepsV5().adImagesGetAllHashes(LOGIN);
        assumeThat("у пользователя есть не менее 2 картинок", imageHashes, iterableWithSize(greaterThanOrEqualTo(2)));
        ArrayList<BannerImagesFormatsRecord> formats =
                imageHashes.stream().map(imageHash -> api.userSteps.getDirectJooqDbSteps()
                .useShard(shard).imagesSteps().getBannerImagesFormatsRecords(imageHash)).collect(Collectors.toCollection(ArrayList::new));
        formats.get(0);
        String imageHash = formats.stream().filter(bannerImagesFormatsRecord -> bannerImagesFormatsRecord.getImageType()
                .equals(BannerImagesFormatsImageType.image_ad)).findFirst().get().getImageHash();
        //BannerImagesFormatsImageType.wide - можно и для ТГО и для РМП
        String imageHashOld =
                formats.stream().filter(bannerImagesFormatsRecord -> bannerImagesFormatsRecord.getImageType()
                .equals(BannerImagesFormatsImageType.wide)).findFirst().get().getImageHash();

        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, adGroupType);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        if (campaignType.equals(CampaignType.TEXT)) {
            picBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                    .withAdGroupId(pid)
                    .withTextAd(new TextAdAddMap()
                            .defaultTextAd()
                            .withAdImageHash(imageHashOld)));
        } else {
            picBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                    .withAdGroupId(pid)
                    .withMobileAppAd(new MobileAppAdAddMap()
                            .defaultMobileAppAd()
                            .withAdImageHash(imageHashOld)));
        }

        graphicBid = api.userSteps.adsSteps().addAdWithAdImageHash(pid, adGroupType, BannerType.IMAGE_AD, imageHash);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps().setBannerImagesStatusModerateByBid(picBid,
                BannerImagesStatusmoderate.Yes);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(graphicBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setImageStatusModerate(graphicBid, imageHash, ImagesStatusmoderate.Yes);

    }

    @Test
    @Title("Добавление в очередь графического баннера и текстового баннера с картиночным в новой группе")
    public void testAddingToBsQueue() {
        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());

        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, notNullValue());

        Map picBanner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, picBid);
        assertThat("Ожидаем, что в БК может быть отправлен картиночный баннер", picBanner, notNullValue());

        Map graphicBanner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid,
                graphicBid);
        assertThat("Ожидаем, что в БК может быть отправлен графический баннер", graphicBanner, notNullValue());

        Map phrase = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена фраза", phrase, notNullValue());
    }
}
