package ru.yandex.autotests.directintapi.bstransport.main.imagead.transmit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Resources;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 16/06/16.
 * https://st.yandex-team.ru/TESTIRT-9352
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Неотправка поля Banner.Resources для неграфического баннера")
@Stories(StoriesNames.IMAGE_AD_BANNER_ACTION_SEND)
@Issue("https://st.yandex-team.ru/DIRECT-54196")
@Features(FeatureNames.IMAGE_ADS)
public class BsTransportBannerResourcesForNotImageAdTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private Long cid;
    private Long pid;
    private Long bid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    public void testNotSendingBannerResourcesForDTO() {
        cid = api.userSteps.campaignSteps().addDefaultCampaign(CampaignType.DYNAMIC);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, AdGroupType.DYNAMIC);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        bid = api.userSteps.adsSteps().addDefaultAd(pid, BannerType.DYNAMIC);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        checkNoResources(resp, "у баннера ДТО");
    }

    @Test
    public void testNotSendingBannerResourcesForText() {
        cid = api.userSteps.campaignSteps().addDefaultCampaign(CampaignType.TEXT);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, AdGroupType.BASE);
        bid = api.userSteps.adsSteps().addDefaultAd(pid, BannerType.TEXT);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        checkNoResources(resp, "у текстового баннера");
    }

    @Test
    public void testNotSendingBannerResourcesForMobile() {
        cid = api.userSteps.campaignSteps().addDefaultCampaign(CampaignType.MOBILE_CONTENT);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, AdGroupType.MOBILE_CONTENT);
        bid = api.userSteps.adsSteps().addDefaultAd(pid, BannerType.MOBILE_CONTENT);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        checkNoResources(resp, "у РМП баннера");
    }

    private void checkNoResources(RunBsTransportScriptResponse resp, String where) {
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        Resources resources = banner != null ? banner.getResources() : null;
        String[] mediaImage = resources != null ? resources.getMediaImage() : null;
        String domain = resources != null ? resources.getDomain() : null;
        String url = resources != null ? resources.getUrl() : null;
        String title = resources != null ? resources.getTitle() : null;
        String body = resources != null ? resources.getBody() : null;
        assertThat(where + " в Banner.Resources не отправлено ГО-специфичных полей",
                mediaImage == null && domain == null && url == null && title == null && body == null,
                is(true));
    }
}

