package ru.yandex.autotests.directintapi.bstransport.main.imagead.transmit;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesFormatsImageType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.GroupParamsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.HrefOpeningParams;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Resources;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.hamcrest.core.IsNull.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 16/06/16.
 * https://st.yandex-team.ru/TESTIRT-9352
 * https://st.yandex-team.ru/TESTIRT-10272
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title(" Отправка поля Banner.Resources.ClickUrlTail для графического баннера")
@Stories(StoriesNames.IMAGE_AD_BANNER_ACTION_SEND)
@Features(FeatureNames.IMAGE_ADS)
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-54196"),
        @Issue("https://st.yandex-team.ru/DIRECT-58548")})
@RunWith(Parameterized.class)
public class BsTransportImageAdResourcesClickUrlTailTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private Long cid;
    private Long pid;
    private Long bid;

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameters(name = "Тип кампаниии: {0}, тип группы: {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, adGroupType);
        String imageHash = api.userSteps.imagesStepsV5().adImagesGetAllHashes(LOGIN).get(0);
        assumeThat("выбрана картинка правильного формата", api.userSteps.getDirectJooqDbSteps().useShard(shard)
                        .imagesSteps().getBannerImagesFormatsRecords(imageHash).getImageType(),
                equalTo(BannerImagesFormatsImageType.image_ad));
        bid = api.userSteps.adsSteps().addAdWithAdImageHash(pid, adGroupType, BannerType.IMAGE_AD, imageHash);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().imagesSteps()
                .setImageStatusModerate(bid, imageHash, ImagesStatusmoderate.Yes);
    }

    @Test
    @Title("Отправка графического баннера с ClickUrlTail")
    public void testSendingWithGroupClickUrlTail() {
        //Add ClickUrlTail
        GroupParamsRecord groupParams = new GroupParamsRecord()
                .setPid(pid)
                .setHasPhraseidHref(1)
                .setHrefParams("value=" + HrefOpeningParams.CAMPAIGNID.getParamName());
        api.userSteps.getDirectJooqDbSteps().adGroupsSteps().saveGroupParams(groupParams);

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        Resources resources = banner != null ? banner.getResources() : null;
        assumeThat("в БК не отправляется Context.Resources.ClickUrlTail для графического баннера"
                , context.getResources().getClickUrlTail(), nullValue());
        assumeThat("в БК отправлено Banner.Resources для графического баннера", resources, notNullValue());
        assertThat("значение Banner.Resources.ClickUrlTail для графического баннера отправлено верно"
                , resources.getClickUrlTail()
                , nullValue());
    }

    @Test
    @Title("Отправка графического баннера без ClickUrlTail")
    public void testSendingWithoutGroupClickUrlTail() {
        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        Resources bannerResources = banner != null ? banner.getResources() : null;
        assumeThat("в БК отправлено Banner.Resources для графического баннера", bannerResources, notNullValue());
        assertThat("значение Banner.Resources.ClickUrlTail для графического баннера отправлено пустое"
                , bannerResources.getClickUrlTail()
                , nullValue());
    }
}

