package ru.yandex.autotests.directintapi.bstransport.main.internalads;

import java.util.HashMap;
import java.util.Map;

import javax.util.streamex.StreamEx;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingMode;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsValueJoinType;
import ru.yandex.autotests.directapi.darkside.model.internalads.AdditionalTargetingValuesBuilder;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

public class AdgroupAdditionalTargetingsValuesTestData {

    public static final String YANDEXUIDS = JsonUtils.toString(ImmutableList.of("87654321", "12345678"));
    public static final String DEVICE_NAMES = getListValuesJson("YNDX-000SB", "YNDX-001");

    public static final String INTERFACE_LANGS = getListValuesJson("ru", "en", "uk", "by", "kz", "tr", "tt");

    //desktop_installed_apps - ["browser", "sethome", ...]
    // допустимые значения: https://a.yandex-team.ru/arc_vcs/direct/core/src/main/java/ru/yandex/direct/core/entity/adgroupadditionaltargeting/DistribSoftConstants.java?rev=r5435964#L16
    public static final String DESKTOP_INSTALLED_APPS = getListValuesJson("1", "2", "3", "4", "5", "6");

    public static final String QUERY_REFERERS = getListValuesJson("%clid=1%", "%yandex.com.tr%");

    public static final String USER_AGENT = getListValuesJson("%muiu%", "%MiuiBrowser%", "Ya%");

    public static final String YP_COOKIES = getListValuesJson("AAAA", "bbbCCCCC");

    public static final String FEATURES_IN_PP = getListValuesJson("ddDD", "EEEEEffff");

    public static final String DEVICE_VENDORS = AdditionalTargetingValuesBuilder.init()
            .addValue(1L)
            .addValue(23L)
            .buildJson();

    public static final String OS_NAMES = AdditionalTargetingValuesBuilder.init()
            .addValue(3L)
            .addValue(4L)
            .buildJson();

    public static final String BROWSER_NAMES = AdditionalTargetingValuesBuilder.init()
            .addValue(1L, "12345", "30000")
            .addValue(2L, "1000", null)
            .buildJson();

    public static final String BROWSER_ENGINES = AdditionalTargetingValuesBuilder.init()
            .addValue(2L, "123", "345")
            .buildJson();

    public static final String OS_FAMILIES = AdditionalTargetingValuesBuilder.init()
            .addValue(11L, "1", "2")
            .addValue(12L, "5", null)
            .addValue(13L, null, null)
            .buildJson();

    //здесь не заданны типы, для которых значения null
    // internal_network, is_mobile, is_tablet, is_touch, is_tv
    public static final Map<AdgroupAdditionalTargetingsTargetingType, String>
            ADGROUP_ADDITIONAL_TARGETINGS_TEST_VALUES =
            new HashMap<AdgroupAdditionalTargetingsTargetingType, String>() {
                {
                    put(AdgroupAdditionalTargetingsTargetingType.yandexuids, YANDEXUIDS);
                    put(AdgroupAdditionalTargetingsTargetingType.browser_engines, BROWSER_ENGINES);
                    put(AdgroupAdditionalTargetingsTargetingType.browser_names, BROWSER_NAMES);
                    put(AdgroupAdditionalTargetingsTargetingType.os_families, OS_FAMILIES);
                    put(AdgroupAdditionalTargetingsTargetingType.os_names, OS_NAMES);
                    put(AdgroupAdditionalTargetingsTargetingType.user_agent, USER_AGENT);
                    put(AdgroupAdditionalTargetingsTargetingType.query_referers, QUERY_REFERERS);
                    put(AdgroupAdditionalTargetingsTargetingType.desktop_installed_apps, DESKTOP_INSTALLED_APPS);
                    put(AdgroupAdditionalTargetingsTargetingType.device_names, DEVICE_NAMES);
                    put(AdgroupAdditionalTargetingsTargetingType.device_vendors, DEVICE_VENDORS);
                    put(AdgroupAdditionalTargetingsTargetingType.interface_langs, INTERFACE_LANGS);
                    put(AdgroupAdditionalTargetingsTargetingType.internal_network, null);
                    put(AdgroupAdditionalTargetingsTargetingType.yp_cookies, YP_COOKIES);
                    put(AdgroupAdditionalTargetingsTargetingType.features_in_pp, FEATURES_IN_PP);
                    // значение проставляется в тесте, т.к. нужно сначала создать mobileContent
                    put(AdgroupAdditionalTargetingsTargetingType.mobile_installed_apps, null);
                }
            };

    public static final Map<AdgroupAdditionalTargetingsTargetingType, AdgroupAdditionalTargetingsTargetingMode>
            ADGROUP_ADDITIONAL_TARGETINGS_TEST_MODES =
            ImmutableMap.<AdgroupAdditionalTargetingsTargetingType, AdgroupAdditionalTargetingsTargetingMode>builder()
                    .put(AdgroupAdditionalTargetingsTargetingType.yandexuids,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.browser_engines,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.browser_names,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.os_families,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.os_names,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.user_agent,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.query_referers,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.desktop_installed_apps,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.device_names,
                            AdgroupAdditionalTargetingsTargetingMode.filtering)
                    .put(AdgroupAdditionalTargetingsTargetingType.device_vendors,
                            AdgroupAdditionalTargetingsTargetingMode.filtering)
                    .put(AdgroupAdditionalTargetingsTargetingType.interface_langs,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.internal_network,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.is_mobile,
                            AdgroupAdditionalTargetingsTargetingMode.filtering)
                    .put(AdgroupAdditionalTargetingsTargetingType.yp_cookies,
                            AdgroupAdditionalTargetingsTargetingMode.targeting)
                    .put(AdgroupAdditionalTargetingsTargetingType.features_in_pp,
                            AdgroupAdditionalTargetingsTargetingMode.filtering)
                    .put(AdgroupAdditionalTargetingsTargetingType.mobile_installed_apps,
                            AdgroupAdditionalTargetingsTargetingMode.filtering)
                    .build();

    public static final Map<AdgroupAdditionalTargetingsTargetingType, AdgroupAdditionalTargetingsValueJoinType>
            ADGROUP_ADDITIONAL_TARGETINGS_TEST_JOIN_TYPES =
            ImmutableMap.<AdgroupAdditionalTargetingsTargetingType, AdgroupAdditionalTargetingsValueJoinType>builder()
                    .put(AdgroupAdditionalTargetingsTargetingType.yandexuids,
                            AdgroupAdditionalTargetingsValueJoinType.any)
                    .put(AdgroupAdditionalTargetingsTargetingType.browser_engines,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.browser_names,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.os_families,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.os_names,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.user_agent,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.query_referers,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.desktop_installed_apps,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.device_names,
                            AdgroupAdditionalTargetingsValueJoinType.any)
                    .put(AdgroupAdditionalTargetingsTargetingType.device_vendors,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.interface_langs,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.internal_network,
                            AdgroupAdditionalTargetingsValueJoinType.any)
                    .put(AdgroupAdditionalTargetingsTargetingType.is_mobile,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.yp_cookies,
                            AdgroupAdditionalTargetingsValueJoinType.any)
                    .put(AdgroupAdditionalTargetingsTargetingType.features_in_pp,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .put(AdgroupAdditionalTargetingsTargetingType.mobile_installed_apps,
                            AdgroupAdditionalTargetingsValueJoinType.all)
                    .build();

    public static String getListValuesJson(String... values) {
        return JsonUtils.toString(StreamEx.of(values).toList());
    }

}
