package ru.yandex.autotests.directintapi.bstransport.main.internalads;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.annotation.Nullable;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

import ru.yandex.autotests.direct.db.beans.ads.internal.BannersInternalTemplateVariablesBuilder;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingMode;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsValueJoinType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusarch;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusautobudgetshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusshowsforecast;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupAdditionalTargetingsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersInternalRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Resources;
import ru.yandex.autotests.directapi.darkside.model.internalads.MobileInstalledAppsTargetingValuesBuilder;
import ru.yandex.autotests.directapi.darkside.steps.ScriptParamsProfiles;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.fail;
import static ru.yandex.autotests.directapi.darkside.model.MobileContentUtils.getDefaultMobileContent;
import static ru.yandex.autotests.directintapi.bstransport.main.internalads.AdgroupAdditionalTargetingsValuesTestData.ADGROUP_ADDITIONAL_TARGETINGS_TEST_JOIN_TYPES;
import static ru.yandex.autotests.directintapi.bstransport.main.internalads.AdgroupAdditionalTargetingsValuesTestData.ADGROUP_ADDITIONAL_TARGETINGS_TEST_MODES;
import static ru.yandex.autotests.directintapi.bstransport.main.internalads.AdgroupAdditionalTargetingsValuesTestData.ADGROUP_ADDITIONAL_TARGETINGS_TEST_VALUES;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

public abstract class InternalAdsBaseTest {

    protected static final String LOGIN = Logins.LOGIN_TRANSPORT_INTERNAL_ADS;
    // существующий шаблон с ресурсами из таблицы: ppcdict.template_resource
    protected static final Long DEFAULT_TEMPLATE_ID = 642L;
    // ресурсы привязанные к шаблону DEFAULT_TEMPLATE_ID
    protected static final Long IMAGE_RESOURCE_TEMPLATE_ID = 2780L;
    protected static final Long URL_RESOURCE_TEMPLATE_ID = 2781L;
    protected static final Long TEXT_RESOURCE_TEMPLATE_ID = 2778L;

    private static final Integer RANDOM_SYMBOLS_COUNT = 6;
    private static final String APP_STORE_NAME = "App Store";
    private static final String BANNER_ASSUME_STEP_MESSAGE = "в БК отправлен баннер";
    private static final String BANNER_ASSERT_STEP_MESSAGE = "Значение параметров баннера соответствует ожиданиям";

    protected static int shard;
    protected static DirectJooqDbSteps dbSteps;
    static TransportHelpSteps transportHelpSteps;

    protected Long cid;
    protected Long pid;
    protected Long bid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public EnsureInternalAdProductPresentRule ensureInternalAdProductPresentRule =
            new EnsureInternalAdProductPresentRule(LOGIN);

    private Long createInternalAdgroups(Long clientId, Long cid,
                                        @Nullable List<AdgroupAdditionalTargetingsRecord> additionalTargetings) {
        PhrasesRecord record = new PhrasesRecord()
                .setAdgroupType(PhrasesAdgroupType.internal)
                .setCid(cid)
                .setGroupName("Группа внутренней рекламы " + RandomUtils.getString(RANDOM_SYMBOLS_COUNT))
                .setGeo("225")
                .setStatusmoderate(PhrasesStatusmoderate.Yes)
                .setStatuspostmoderate(PhrasesStatuspostmoderate.Yes)
                .setStatusbssynced(PhrasesStatusbssynced.No)
                .setStatusshowsforecast(PhrasesStatusshowsforecast.New)
                .setStatusautobudgetshow(PhrasesStatusautobudgetshow.Yes);

        Long pid = dbSteps.adGroupsSteps().addAdGroup(record, clientId);

        dbSteps.adGroupsInternalSteps().addAdGroupInternal(pid, 1L);

        if (additionalTargetings != null && !additionalTargetings.isEmpty()) {
            additionalTargetings.forEach(
                    targeting -> {
                        targeting.setPid(pid);
                        dbSteps.adGroupsInternalSteps().addAdGroupAdditionalTargetings(targeting);
                    }
            );
        }
        return pid;
    }

    @Step("Создание тестовой группы для внутренней рекламы c таргетингом device_names")
    Long createInternalAdgroupsWithDefaultAdditionalTargeting(Long clientId, Long cid) {
        return createInternalAdgroups(clientId, cid,
                Collections.singletonList(
                        createAdGroupAdditionalTargetingRecord(
                                AdgroupAdditionalTargetingsTargetingType.device_names)));
    }

    @Step("Создание группы для внутренней рекламы c набором таргетингов (cid: {1}, additionalTargetingTypes: {2})")
    Long createInternalAdgroupsWithAdditionalTargetings(Long clientId, Long cid,
                                                        @Nullable Collection<AdgroupAdditionalTargetingsTargetingType> additionalTargetingsTypes) {
        if (additionalTargetingsTypes == null) {
            return createInternalAdgroups(clientId, cid, null);
        }
        List<AdgroupAdditionalTargetingsRecord> additionalTargetings = new ArrayList<>();
        additionalTargetingsTypes.forEach(
                type -> {
                    AdgroupAdditionalTargetingsRecord record = createAdGroupAdditionalTargetingRecord(type);
                    if (type == AdgroupAdditionalTargetingsTargetingType.mobile_installed_apps) {
                        String targetingValue = createMobileContentAndGetTargetingJsonValue(clientId.toString());
                        record.setValue(targetingValue);
                    }

                    additionalTargetings.add(record);
                }
        );

        return createInternalAdgroups(clientId, cid, additionalTargetings);
    }

    private String createMobileContentAndGetTargetingJsonValue(String clientId) {
        MobileContentRecord mobileContentRecord = getDefaultMobileContent(clientId);
        Long mobileContentId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .mobileContentSteps().saveMobileContent(mobileContentRecord);

        return MobileInstalledAppsTargetingValuesBuilder.init()
                .addValue(mobileContentId, mobileContentRecord.getBundleId() + APP_STORE_NAME)
                .buildJson();
    }

    @Step("Добавление к группе дополнительных таргетинов (pid:{0}, additionalTargetingTypes:{1}")
    void appendAdditionalTargetings(Long pid,
                                    Collection<AdgroupAdditionalTargetingsTargetingType> additionalTargetingsTypes) {
        additionalTargetingsTypes.forEach(
                type -> {
                    AdgroupAdditionalTargetingsRecord additionalTargeting =
                            createAdGroupAdditionalTargetingRecord(type);
                    additionalTargeting.setPid(pid);
                    dbSteps.adGroupsInternalSteps().addAdGroupAdditionalTargetings(additionalTargeting);
                }
        );
    }

    @Step("Создание баннера для внутренней рекламы")
    Long createInternalBanner(Long clientId, Long cid, Long pid) {
        BannersRecord record = new BannersRecord()
                .setBannerType(BannersBannerType.internal)
                .setPid(pid)
                .setCid(cid)
                .setTitle("Заголовок " + RandomUtils.getString(RANDOM_SYMBOLS_COUNT))
                .setBody(RandomUtils.getString(RANDOM_SYMBOLS_COUNT))
                .setBannerid(0L)
                .setOpts("")
                .setStatusactive(BannersStatusactive.Yes)
                .setStatusshow(BannersStatusshow.Yes)
                .setStatusarch(BannersStatusarch.No)
                .setStatusbssynced(BannersStatusbssynced.No)
                .setStatusmoderate(BannersStatusmoderate.Yes)
                .setStatuspostmoderate(BannersStatuspostmoderate.Yes)
                .setStatussitelinksmoderate(BannersStatussitelinksmoderate.New);

        Long bid = dbSteps.bannersSteps().addBanner(record, clientId);
        dbSteps.adGroupsSteps().setPhrasesBid(pid, bid);

        dbSteps.bannersInternalSteps().addBannerInternal(createDefaultBannersInternalRecord(bid));
        return bid;
    }

    private BannersInternalRecord createDefaultBannersInternalRecord(@Nullable Long bid) {
        return new BannersInternalRecord()
                .setBid(bid)
                .setDescription("test description")
                .setTemplateId(DEFAULT_TEMPLATE_ID)
                .setTemplateVariables(BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(TEXT_RESOURCE_TEMPLATE_ID, RandomStringUtils.randomAlphabetic(11))
                        .buildJson());
    }

    /**
     * Создает тестовую запись для ppc.adgroup_additional_targetings
     * Для заданного типа таргетинга создает соответствующие тестовые значения
     */
    private AdgroupAdditionalTargetingsRecord createAdGroupAdditionalTargetingRecord(
            AdgroupAdditionalTargetingsTargetingType targetingType) {
        return new AdgroupAdditionalTargetingsRecord()
                .setTargetingType(targetingType)
                .setTargetingMode(ADGROUP_ADDITIONAL_TARGETINGS_TEST_MODES
                        .getOrDefault(targetingType, AdgroupAdditionalTargetingsTargetingMode.filtering))
                .setValueJoinType(ADGROUP_ADDITIONAL_TARGETINGS_TEST_JOIN_TYPES
                        .getOrDefault(targetingType, AdgroupAdditionalTargetingsValueJoinType.all))
                .setValue(ADGROUP_ADDITIONAL_TARGETINGS_TEST_VALUES.getOrDefault(targetingType, null));
    }


    Campaign sendNewCampaign() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaignWithProfile(shard, cid, ScriptParamsProfiles.ProfileNames.INTERNAL_ADS);

        return api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
    }

    Campaign sendSyncedCampaign() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendSyncedCampaignWithProfile(shard, cid, ScriptParamsProfiles.ProfileNames.INTERNAL_ADS);

        return api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
    }

    protected void resetStatusBsSyncedOfAllObjects() {
        dbSteps.campaignsSteps().setCampaignsStatusBsSynced(cid, CampaignsStatusbssynced.No);
        dbSteps.adGroupsSteps().setPhrasesStatusBsSynced(pid, PhrasesStatusbssynced.No);
        dbSteps.bannersSteps().setBannerStatusBsSynced(bid, BannersStatusbssynced.No);
    }

    protected Banner sendCampaignToBsAndCheckBannerParams(boolean isNewCampaign) {
        Banner expectedBanner = transportHelpSteps.buildExpectedBannerInternalObjFromDb(bid, shard, UpdateInfo.UPDATE);

        Campaign campaign = isNewCampaign ? sendNewCampaign() : sendSyncedCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;

        assumeThat(BANNER_ASSUME_STEP_MESSAGE, banner, notNullValue());
        assertThat(BANNER_ASSERT_STEP_MESSAGE,
                banner,
                beanDiffer(expectedBanner).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));

        return banner;
    }

    protected Banner sendCampaignToBsAndCheckNewBannerParams(boolean isNewCampaign) {
        Banner expectedBanner = transportHelpSteps.buildExpectedNewBannerInternalObjFromDb(bid, shard);

        Campaign campaign = isNewCampaign ? sendNewCampaign() : sendSyncedCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;

        assumeThat(BANNER_ASSUME_STEP_MESSAGE, banner, notNullValue());
        assertThat(BANNER_ASSERT_STEP_MESSAGE,
                banner,
                beanDiffer(expectedBanner).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));

        return banner;
    }

    protected void sendCampaignToBsAndCheckNewBannerResources(Resources expectedResources) {
        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;

        assumeThat(BANNER_ASSUME_STEP_MESSAGE, banner, notNullValue());
        Resources resources = banner.getResources();
        assertThat(BANNER_ASSERT_STEP_MESSAGE,
                resources,
                beanDiffer(expectedResources).useCompareStrategy(DefaultCompareStrategies.onlyFields(
                        BeanFieldPath.newPath("templateVariables"),
                        BeanFieldPath.newPath("unifiedTemplateVariables")
                )));
    }

    protected void sendCampaignToBsAndExpectExceptionOnRunningBsClientDataScript() {
        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord before = dbSteps.transportSteps().getBsExportQueueRecord(cid);
        try {
            api.userSteps.getDarkSideSteps().getTransportSteps()
                    .runBsClientDataScript(shard, cid, ScriptParamsProfiles.ProfileNames.INTERNAL_ADS);
            fail("исключения не случилось");
        } catch (DarkSideException e) {
            assertThat("вернулся правильный тип исключения",
                    e.getMessage(), equalTo("Ошибка выполнения bsClientData.pl: code =70"));
        }
        BsExportQueueRecord bsExportQueueRecord = dbSteps.transportSteps().getBsExportQueueRecord(cid);
        assumeThat("в таблице ppc.bs_export_queue есть запись для cid=" + cid, bsExportQueueRecord, notNullValue());
        assertThat("в таблице ppc.bs_export_queue seq_time больше чем queue_time - это значит кампанию двинули дальше" +
                        " в очереди",
                bsExportQueueRecord.getSeqTime(), greaterThan(before.getQueueTime()));
    }

    static class EnsureInternalAdProductPresentRule implements TestRule {
        private final String login;

        EnsureInternalAdProductPresentRule(String login) {
            this.login = login;
        }

        @Override
        public Statement apply(Statement statement, Description description) {
            return new Statement() {
                @Override
                public void evaluate() throws Throwable {
                    DirectJooqDbSteps jooqSteps = api.userSteps.getDirectJooqDbSteps();
                    Long clientId = jooqSteps.shardingSteps().getClientIdByLogin(login);
                    int shard = jooqSteps.shardingSteps().getShardByLogin(login);
                    jooqSteps.useShard(shard);
                    jooqSteps.internalAdProductSteps().ensureIsInternalAdProduct(clientId, login);

                    statement.evaluate();
                }
            };
        }
    }
}
