package ru.yandex.autotests.directintapi.bstransport.main.internalads;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.SoftAssertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CampaignRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.beans.ads.internal.BannersInternalTemplateVariablesBuilder;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.DirectTemplateState;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.DirectTemplateResourceRecord;
import ru.yandex.autotests.direct.httpclient.TestEnvironment;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Resources;
import ru.yandex.autotests.directapi.darkside.model.internalads.BsTemplateVariables;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/*
Для шаблонов, переведённых на единый, может потребоваться восстановить данные в базе и обновить id в тесте:
INSERT INTO direct_template (format_name, state) VALUES ("test1", "unified");
INSERT INTO direct_template_resource
    (direct_template_id, resource_no, unified_resource_no, unified_template_resource_id, options)
    VALUES (1000001, 17, 17, 5980, 'banana_image');

Для старых шаблонов может потребоваться их смигрировать на единый формат вручную:
INSERT INTO direct_template (direct_template_id, format_name, state)
    VALUES (422, "test2", "default"), (433, "test3", "transitional"), (184, "test4", "unified");
INSERT INTO direct_template_resource
    (direct_template_resource_id, direct_template_id, resource_no, unified_resource_no, unified_template_resource_id)
    VALUES (817, 184, 1, 14, 5977), (1973, 422, 1, 54, 6017), (2025, 433, 1, 54, 6017);

Для автоинкрементных (id > 1_000_000) хотим обновить их id в тесте, находим их:
select * from direct_template where format_name like "test%";
+--------------------+-------------+--------------+
| direct_template_id | format_name | state        |
+--------------------+-------------+--------------+
|                184 | test4       | unified      |
|                422 | test2       | default      |
|                433 | test3       | transitional |
|            1000001 | test1       | unified      |
+--------------------+-------------+--------------+
select * from direct_template_resource where unified_resource_no in (14, 54, 17);
+-----------------------------+--------------------+-------------+---------------------+------------------------------+--------------+
| direct_template_resource_id | direct_template_id | resource_no | unified_resource_no | unified_template_resource_id | options      |
+-----------------------------+--------------------+-------------+---------------------+------------------------------+--------------+
|                         817 |                184 |           1 |                  14 |                         5977 |              |
|                        1973 |                422 |           1 |                  54 |                         6017 |              |
|                        2025 |                433 |           1 |                  54 |                         6017 |              |
|                     1000001 |            1000001 |          17 |                  17 |                         5980 | banana_image |
+-----------------------------+--------------------+-------------+---------------------+------------------------------+--------------+
*/

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку баннеров с внутренней рекламой (internal_distrib)")
@Features(FeatureNames.INTERNAL_ADS)
@Issue("https://st.yandex-team.ru/DIRECT-94077")
public class InternalDistribCampaignBannersParamsTest extends InternalAdsBaseTest {

    private static final String NOT_EXIST_IMAGE_HASH = "_";
    private static final String URL = "https://ya.ru";
    private static final String IMAGE_URL =
            "https://avatars.mdst.yandex.net/get-direct/4699/JrmHedpCRkxmY2EZIxgjVA/orig";
    private static final String REAL_TEMPLATE_LEFT_BEHIND_RESOURCE_VALUE = "product";
    private static final String REAL_TEMPLATE_NEW_RESOURCE_VALUE = "login";
    private static final int IMAGE_WIDTH = 450;
    private static final int IMAGE_HEIGHT = 600;
    private static final int UNIFIED_TEMPLATE_ID = 3350;
    private static final long FORMAT_RESOURCE_ID = 6152L;
    private static final long ORIG_TEMPLATE_RESOURCE_ID = 6153L;
    private static final long DEFAULT_STATE_TEMPLATE_ID = 422L;
    private static final long DEFAULT_STATE_TEMPLATE_RESOURCE_ID = 1973L;
    private static final long TRANSITIONAL_STATE_TEMPLATE_ID = 433L;
    private static final long TRANSITIONAL_STATE_TEMPLATE_RESOURCE_ID = 2025L;
    private static final long TRANSITIONAL_STATE_UNIFIED_TEMPLATE_RESOURCE_ID = 6017L;
    private static final long UNIFIED_STATE_TEMPLATE_ID = 184L;
    private static final long UNIFIED_STATE_TEMPLATE_RESOURCE_ID = 817L;
    private static final long UNIFIED_STATE_UNIFIED_TEMPLATE_RESOURCE_ID = 5977L;
    private static final long DIRECT_TEMPLATE_ID = 1_000_001L;
    private static final long DIRECT_TEMPLATE_RESOURCE_ID = 1_000_001L;
    private static final long DIRECT_TEMPLATE_UNIFIED_TEMPLATE_RESOURCE_ID = 5980L;
    private static final long REAL_TEMPLATE_MIGRATED_TEMPLATE_ID = 3010L;
    private static final long REAL_TEMPLATE_MIGRATED_RESOURCE_ID = 3884L;
    private static final long REAL_TEMPLATE_MIGRATED_UNIFIED_TEMPLATE_RESOURCE_ID = 6053L;
    private static final long REAL_TEMPLATE_LEFT_BEHIND_RESOURCE_ID = 3885L;
    private static final long REAL_TEMPLATE_NEW_UNIFIED_TEMPLATE_RESOURCE_ID = 5966L;
    private static final long REAL_TEMPLATE_NO_FORMAT_TEMPLATE_ID = 641L;
    private static final long REAL_TEMPLATE_NO_FORMAT_RESOURCE_ID = 2772L;
    private static final long REAL_TEMPLATE_NO_FORMAT_UNIFIED_TEMPLATE_RESOURCE_ID = 6000L;
    private static final short FORMAT_RESOURCE_NO = 94;
    private static final short ORIG_TEMPLATE_RESOURCE_NO = 95;
    private static final short TRANSITIONAL_STATE_UNIFIED_RESOURCE_NO = 54;
    private static final short UNIFIED_STATE_UNIFIED_RESOURCE_NO = 14;
    private static final short DIRECT_TEMPLATE_UNIFIED_RESOURCE_NO = 17;
    /* dt:ppcdict> select unified_resource_no from direct_template_resource where
     * direct_template_id = 3010 and direct_template_resource_id = 3884;
     */
    private static final short REAL_TEMPLATE_MIGRATED_UNIFIED_RESOURCE_NO = 90;
    private static final short REAL_TEMPLATE_NEW_RESOURCE_NO = 1100;
    private static final short REAL_TEMPLATE_NEW_UNIFIED_RESOURCE_NO = 3;
    private static final short REAL_TEMPLATE_NO_FORMAT_UNIFIED_RESOURCE_NO = 37;

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CampaignRule campaignRule = new CampaignRule()
            .withMediaType(CampaignTypeEnum.INTERNAL_DISTRIB)
            .withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(campaignRule);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
        dbSteps = TestEnvironment.newDbSteps().useShard(shard);
        transportHelpSteps = new TransportHelpSteps(api).useDbJooqSteps(dbSteps);
    }

    private String imageHash;

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = campaignRule.getCampaignId();
        api.userSteps.campaignFakeSteps().makeCampaignInternalReadyForSendingToBS(cid);

        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithDefaultAdditionalTargeting(clientId, cid);
        bid = createInternalBanner(clientId, cid, pid);

        String[] imageHashes = transportHelpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.REGULAR);
        imageHash = imageHashes[0];
    }


    @Test
    public void createInternalFreeCampaign_commonBannerParamsCheck() {
        sendCampaignToBsAndCheckNewBannerParams(true);
    }

    @Test
    public void createInternalFreeCampaign_expectBsClientDataDie_whenTemplateVariableWithNotExistImage() {
        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(IMAGE_RESOURCE_TEMPLATE_ID, NOT_EXIST_IMAGE_HASH)
                        .buildJson());

        sendCampaignToBsAndExpectExceptionOnRunningBsClientDataScript();
    }

    @Test
    public void createInternalFreeCampaign_templateVariablesValueWithCyrillicSymbols() {
        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(TEXT_RESOURCE_TEMPLATE_ID, "три четыре five")
                        .addTemplateVariable(URL_RESOURCE_TEMPLATE_ID, RandomStringUtils.randomAlphabetic(11))
                        .buildJson());

        sendCampaignToBsAndCheckNewBannerParams(true);
    }

    @Test
    public void updateInternalFreeCampaign_changeTemplateVariables() {
        sendNewCampaign();

        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(IMAGE_RESOURCE_TEMPLATE_ID, imageHash)
                        .addTemplateVariable(TEXT_RESOURCE_TEMPLATE_ID, "0")
                        .addTemplateVariable(URL_RESOURCE_TEMPLATE_ID, RandomStringUtils.randomAlphabetic(11))
                        .buildJson());

        resetStatusBsSyncedOfAllObjects();

        sendCampaignToBsAndCheckBannerParams(false);
    }

    @Test
    public void sendUnifiedTemplate_defaultState_expectTemplateVariablesOnly() {
        dbSteps.bannersInternalSteps().updateTemplateId(bid, DEFAULT_STATE_TEMPLATE_ID);
        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(DEFAULT_STATE_TEMPLATE_RESOURCE_ID, URL)
                        .buildJson());

        Banner expectedBanner = transportHelpSteps.buildExpectedNewBannerInternalObjFromDb(bid, shard);
        sendCampaignToBsAndCheckNewBannerResources(expectedBanner.getResources());
    }

    @Test
    public void sendUnifiedTemplate_transitionalState_expectTemplateAndUnifiedTemplateVariables() {
        String format = dbSteps.directTemplateSteps().getDirectTemplateFormat(TRANSITIONAL_STATE_TEMPLATE_ID);
        dbSteps.bannersInternalSteps().updateTemplateId(bid, TRANSITIONAL_STATE_TEMPLATE_ID);
        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(TRANSITIONAL_STATE_TEMPLATE_RESOURCE_ID, URL)
                        .buildJson());

        Banner expectedBanner = transportHelpSteps.buildExpectedNewBannerInternalObjFromDb(bid, shard);
        List<BsTemplateVariables> unifiedTemplateVariables = new ArrayList<>();
        unifiedTemplateVariables.add(new BsTemplateVariables()
                .withValue(URL)
                .withTemplateResourceNo(TRANSITIONAL_STATE_UNIFIED_RESOURCE_NO)
                .withTemplatePartNo(0)
                .withTemplateResourceId(TRANSITIONAL_STATE_UNIFIED_TEMPLATE_RESOURCE_ID)
        );
        unifiedTemplateVariables.add(formatResource(format));
        unifiedTemplateVariables.add(origTemplateResource(TRANSITIONAL_STATE_TEMPLATE_ID));
        sendCampaignToBsAndCheckNewBannerResources(expectedBanner.getResources().withUnifiedTemplateVariables(
                unifiedTemplateVariables));
    }

    @Test
    public void sendUnifiedTemplate_unifiedState_expectUnifiedTemplateVariablesOnly() {
        String format = dbSteps.directTemplateSteps().getDirectTemplateFormat(UNIFIED_STATE_TEMPLATE_ID);
        dbSteps.bannersInternalSteps().updateTemplateId(bid, UNIFIED_STATE_TEMPLATE_ID);
        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(UNIFIED_STATE_TEMPLATE_RESOURCE_ID, URL)
                        .buildJson());

        List<BsTemplateVariables> unifiedTemplateVariables = new ArrayList<>();
        unifiedTemplateVariables.add(new BsTemplateVariables()
                .withValue(URL)
                .withTemplateResourceNo(UNIFIED_STATE_UNIFIED_RESOURCE_NO)
                .withTemplatePartNo(0)
                .withTemplateResourceId(UNIFIED_STATE_UNIFIED_TEMPLATE_RESOURCE_ID)
        );
        unifiedTemplateVariables.add(formatResource(format));
        unifiedTemplateVariables.add(origTemplateResource(UNIFIED_STATE_TEMPLATE_ID));
        sendCampaignToBsAndCheckNewBannerResources(new Resources().withUnifiedTemplateVariables(
                unifiedTemplateVariables));
    }

    @Test
    public void sendUnifiedDirectTemplate_unifiedState_expectUnifiedTemplateVariablesOnlyAndNoOrigTemplate() {
        String format = dbSteps.directTemplateSteps().getDirectTemplateFormat(DIRECT_TEMPLATE_ID);
        dbSteps.bannersInternalSteps().updateTemplateId(bid, DIRECT_TEMPLATE_ID);
        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(DIRECT_TEMPLATE_RESOURCE_ID, imageHash)
                        .buildJson());

        List<BsTemplateVariables> unifiedTemplateVariables = new ArrayList<>();
        unifiedTemplateVariables.add(new BsTemplateVariables()
                .withValue(IMAGE_URL)
                .withTemplateResourceNo(DIRECT_TEMPLATE_UNIFIED_RESOURCE_NO)
                .withTemplatePartNo(0)
                .withTemplateResourceId(DIRECT_TEMPLATE_UNIFIED_TEMPLATE_RESOURCE_ID)
                .withWidth(IMAGE_WIDTH)
                .withHeight(IMAGE_HEIGHT)
        );
        unifiedTemplateVariables.add(formatResource(format));
        sendCampaignToBsAndCheckNewBannerResources(new Resources().withUnifiedTemplateVariables(
                unifiedTemplateVariables));
    }

    @Test
    public void sendUnifiedDirectTemplate_transitionalState_expectNoUnmappedResources() {
        String format = dbSteps.directTemplateSteps().getDirectTemplateFormat(REAL_TEMPLATE_MIGRATED_TEMPLATE_ID);
        DirectTemplateResourceRecord newResource = dbSteps.directTemplateSteps().addOrGetDirectTemplateResource(
                REAL_TEMPLATE_MIGRATED_TEMPLATE_ID,
                REAL_TEMPLATE_NEW_RESOURCE_NO,
                REAL_TEMPLATE_NEW_UNIFIED_RESOURCE_NO,
                REAL_TEMPLATE_NEW_UNIFIED_TEMPLATE_RESOURCE_ID,
                ""
        );
        dbSteps.directTemplateSteps().updateDirectTemplateState(REAL_TEMPLATE_MIGRATED_TEMPLATE_ID,
                DirectTemplateState.transitional);
        dbSteps.bannersInternalSteps().updateTemplateId(bid, REAL_TEMPLATE_MIGRATED_TEMPLATE_ID);
        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(REAL_TEMPLATE_MIGRATED_RESOURCE_ID, imageHash)
                        .addTemplateVariable(REAL_TEMPLATE_LEFT_BEHIND_RESOURCE_ID,
                                REAL_TEMPLATE_LEFT_BEHIND_RESOURCE_VALUE)
                        .addTemplateVariable(newResource.getDirectTemplateResourceId(),
                                REAL_TEMPLATE_NEW_RESOURCE_VALUE)
                        .buildJson());

        Banner expectedBanner = transportHelpSteps.buildExpectedNewBannerInternalObjFromDb(bid, shard);
        List<BsTemplateVariables> unifiedTemplateVariables = new ArrayList<>();
        unifiedTemplateVariables.add(new BsTemplateVariables()
                .withValue(IMAGE_URL)
                .withTemplateResourceNo(REAL_TEMPLATE_MIGRATED_UNIFIED_RESOURCE_NO)
                .withTemplatePartNo(0)
                .withTemplateResourceId(REAL_TEMPLATE_MIGRATED_UNIFIED_TEMPLATE_RESOURCE_ID)
                .withWidth(IMAGE_WIDTH)
                .withHeight(IMAGE_HEIGHT)
        );
        unifiedTemplateVariables.add(new BsTemplateVariables()
                .withValue(REAL_TEMPLATE_NEW_RESOURCE_VALUE)
                .withTemplateResourceNo(REAL_TEMPLATE_NEW_UNIFIED_RESOURCE_NO)
                .withTemplatePartNo(0)
                .withTemplateResourceId(REAL_TEMPLATE_NEW_UNIFIED_TEMPLATE_RESOURCE_ID)
        );
        unifiedTemplateVariables.add(formatResource(format));
        unifiedTemplateVariables.add(origTemplateResource(REAL_TEMPLATE_MIGRATED_TEMPLATE_ID));
        sendCampaignToBsAndCheckNewBannerResources(expectedBanner.getResources().withUnifiedTemplateVariables(
                unifiedTemplateVariables));
    }

    @Test
    public void sendUnifiedTemplate_unifiedStateNoFormat_expectNoFormat() {
        String format = dbSteps.directTemplateSteps().getDirectTemplateFormat(REAL_TEMPLATE_NO_FORMAT_TEMPLATE_ID);
        assumeThat("У шаблона нет формата", format, equalTo("0"));

        dbSteps.directTemplateSteps().updateDirectTemplateState(REAL_TEMPLATE_NO_FORMAT_TEMPLATE_ID,
                DirectTemplateState.unified);
        dbSteps.bannersInternalSteps().updateTemplateId(bid, REAL_TEMPLATE_NO_FORMAT_TEMPLATE_ID);
        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(REAL_TEMPLATE_NO_FORMAT_RESOURCE_ID, URL)
                        .buildJson());

        List<BsTemplateVariables> unifiedTemplateVariables = new ArrayList<>();
        unifiedTemplateVariables.add(new BsTemplateVariables()
                .withValue(URL)
                .withTemplateResourceNo(REAL_TEMPLATE_NO_FORMAT_UNIFIED_RESOURCE_NO)
                .withTemplatePartNo(0)
                .withTemplateResourceId(REAL_TEMPLATE_NO_FORMAT_UNIFIED_TEMPLATE_RESOURCE_ID)
        );
        unifiedTemplateVariables.add(origTemplateResource(REAL_TEMPLATE_NO_FORMAT_TEMPLATE_ID));
        sendCampaignToBsAndCheckNewBannerResources(new Resources().withUnifiedTemplateVariables(
                unifiedTemplateVariables));
    }

    @Test
    public void sendOldUnifiedTemplate_expectOldTemplateId() {
        dbSteps.bannersInternalSteps().updateTemplateId(bid, UNIFIED_STATE_TEMPLATE_ID);
        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;

        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assert banner != null; // успокоим линтер, не понимающий проверку выше

        SoftAssertions softly = new SoftAssertions();
        softly.assertThat(banner.getTemplateId()).isEqualTo(Math.toIntExact(UNIFIED_STATE_TEMPLATE_ID));
        softly.assertThat(banner.getDistributionFormatId()).isEqualTo(UNIFIED_STATE_TEMPLATE_ID);
        softly.assertAll();
    }

    @Test
    public void sendDirectOnlyTemplate_expectUnifiedTemplateId() {
        dbSteps.bannersInternalSteps().updateTemplateId(bid, DIRECT_TEMPLATE_ID);
        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;

        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assert banner != null; // успокоим линтер, не понимающий проверку выше

        SoftAssertions softly = new SoftAssertions();
        softly.assertThat(banner.getTemplateId()).isEqualTo(UNIFIED_TEMPLATE_ID);
        softly.assertThat(banner.getDistributionFormatId()).isEqualTo(DIRECT_TEMPLATE_ID);
        softly.assertAll();
    }

    private BsTemplateVariables formatResource(String value) {
        return new BsTemplateVariables()
                .withValue(value)
                .withTemplateResourceNo(FORMAT_RESOURCE_NO)
                .withTemplatePartNo(0)
                .withTemplateResourceId(FORMAT_RESOURCE_ID);
    }

    private BsTemplateVariables origTemplateResource(Long value) {
        return new BsTemplateVariables()
                .withValue(value.toString())
                .withTemplateResourceNo(ORIG_TEMPLATE_RESOURCE_NO)
                .withTemplatePartNo(0)
                .withTemplateResourceId(ORIG_TEMPLATE_RESOURCE_ID);
    }
}
