package ru.yandex.autotests.directintapi.bstransport.main.internalads;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CampaignRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.beans.ads.internal.BannersInternalTemplateVariablesBuilder;
import ru.yandex.autotests.direct.httpclient.TestEnvironment;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;


@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку баннеров с внутренней рекламой (internal_free)")
@Features(FeatureNames.INTERNAL_ADS)
@Issue("https://st.yandex-team.ru/DIRECT-94077")
public class InternalFreeCampaignBannersParamsTest extends InternalAdsBaseTest {

    private static final long NOT_EXIST_TEMPLATE_RESOURCE_ID = -1;

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CampaignRule campaignRule = new CampaignRule()
            .withMediaType(CampaignTypeEnum.INTERNAL_FREE)
            .withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(campaignRule);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
        dbSteps = TestEnvironment.newDbSteps().useShard(shard);
        transportHelpSteps = new TransportHelpSteps(api).useDbJooqSteps(dbSteps);
    }

    private String imageHash;

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = campaignRule.getCampaignId();
        api.userSteps.campaignFakeSteps().makeCampaignInternalReadyForSendingToBS(cid);

        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithDefaultAdditionalTargeting(clientId, cid);
        bid = createInternalBanner(clientId, cid, pid);

        String[] imageHashes = transportHelpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.REGULAR);
        imageHash = imageHashes[0];
    }


    @Test
    public void createInternalFreeCampaign_commonBannerParamsCheck() {
        sendCampaignToBsAndCheckNewBannerParams(true);
    }

    @Test
    public void updateInternalFreeCampaign_changeTemplateVariables() {
        sendNewCampaign();

        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(IMAGE_RESOURCE_TEMPLATE_ID, imageHash)
                        .addTemplateVariable(TEXT_RESOURCE_TEMPLATE_ID, RandomStringUtils.randomAlphabetic(7))
                        .addTemplateVariable(URL_RESOURCE_TEMPLATE_ID, RandomStringUtils.randomAlphabetic(11))
                        .buildJson());

        resetStatusBsSyncedOfAllObjects();

        sendCampaignToBsAndCheckBannerParams(false);
    }

    @Test
    public void updateInternalFreeCampaign_skipTemplateVariablesWithNullValues() {
        sendNewCampaign();

        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(TEXT_RESOURCE_TEMPLATE_ID, RandomStringUtils.randomAlphabetic(7))
                        .addTemplateVariable(URL_RESOURCE_TEMPLATE_ID, null)
                        .addTemplateVariable(IMAGE_RESOURCE_TEMPLATE_ID, null)
                        .buildJson());

        resetStatusBsSyncedOfAllObjects();

        Banner banner = sendCampaignToBsAndCheckBannerParams(false);
        // доп проверка на случай, если в sendCampaignToBsAndCheckBannerParams будет некорректная проверка переменных
        assertThat("в БК отправлено ожидаемое кол-вопеременных баннера", banner.getResources().getTemplateVariables(), hasSize(1));
    }

    @Test
    public void updateInternalFreeCampaign_expectBsClientDataDie_whenTemplateVariablesWithNullAndNotExistTemplateResource() {
        sendNewCampaign();

        dbSteps.bannersInternalSteps().updateTemplateVaribables(bid,
                BannersInternalTemplateVariablesBuilder.init()
                        .addTemplateVariable(NOT_EXIST_TEMPLATE_RESOURCE_ID, RandomStringUtils.randomAlphabetic(7))
                        .addTemplateVariable(null, RandomStringUtils.randomAlphabetic(7))
                        .addTemplateVariable(null, null)
                        .buildJson());

        resetStatusBsSyncedOfAllObjects();

        sendCampaignToBsAndExpectExceptionOnRunningBsClientDataScript();
    }

}
