package ru.yandex.autotests.directintapi.bstransport.main.internalads;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CampaignRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.httpclient.TestEnvironment;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.main.internalads.AdgroupAdditionalTargetingsValuesTestData.ADGROUP_ADDITIONAL_TARGETINGS_TEST_VALUES;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;


@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку групп с внутренней рекламой (internal_free)")
@Features(FeatureNames.INTERNAL_ADS)
@Issue("https://st.yandex-team.ru/DIRECT-94077")
public class InternalFreeCampaignContextParamsTest extends InternalAdsBaseTest {

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CampaignRule campaignRule = new CampaignRule()
            .withMediaType(CampaignTypeEnum.INTERNAL_FREE)
            .withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(campaignRule);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
        dbSteps = TestEnvironment.newDbSteps().useShard(shard);
        transportHelpSteps = new TransportHelpSteps(api).useDbJooqSteps(dbSteps);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = campaignRule.getCampaignId();
        api.userSteps.campaignFakeSteps().makeCampaignInternalReadyForSendingToBS(cid);
    }

    @Test
    public void createInternalFreeCampaign_commonContextCheck() {
        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithDefaultAdditionalTargeting(clientId, cid);
        bid = createInternalBanner(clientId, cid, pid);

        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    public void createInternalFreeCampaign_contextWithStartAndFinishTime() {
        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithDefaultAdditionalTargeting(clientId, cid);
        bid = createInternalBanner(clientId, cid, pid);

        dbSteps.adGroupsInternalSteps().setStartTimeAndFinishTime(pid, Timestamp.valueOf(LocalDateTime.now()),
                Timestamp.valueOf(LocalDateTime.now().plusDays(3)));

        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    public void createInternalFreeCampaign_contextWithoutStartAndFinishTime() {
        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithDefaultAdditionalTargeting(clientId, cid);
        bid = createInternalBanner(clientId, cid, pid);

        dbSteps.adGroupsInternalSteps().setStartTimeAndFinishTime(pid, null, null);

        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    public void createInternalFreeCampaign_checkRfMax() {
        Integer rf = 500;
        Integer rfReset = 30;

        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithDefaultAdditionalTargeting(clientId, cid);
        bid = createInternalBanner(clientId, cid, pid);

        dbSteps.adGroupsInternalSteps().setRfAndRfReset(pid, rf, rfReset);

        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    public void createInternalFreeCampaign_checkRfMaxUnlimit() {
        Integer rf = 0;
        Integer rfReset = 30;

        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithDefaultAdditionalTargeting(clientId, cid);
        bid = createInternalBanner(clientId, cid, pid);

        dbSteps.adGroupsInternalSteps().setRfAndRfReset(pid, rf, rfReset);

        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);
        expectedContext.setMaxRF(0);
        expectedContext.setRfDays(0);

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    public void createInternalFreeCampaign_checkMultipleAdditionalTargetings() {
        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithAdditionalTargetings(clientId, cid,
                ADGROUP_ADDITIONAL_TARGETINGS_TEST_VALUES.keySet());
        bid = createInternalBanner(clientId, cid, pid);

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);

        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    public void createInternalFreeCampaign_checkdditionalTargetingsWithSeveralBanners() {
        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithAdditionalTargetings(clientId, cid,
                ADGROUP_ADDITIONAL_TARGETINGS_TEST_VALUES.keySet());
        bid = createInternalBanner(clientId, cid, pid);
        createInternalBanner(clientId, cid, pid); //создаем второй баннер https://st.yandex-team.ru/DIRECT-117524

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);

        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    public void createInternalFreeCampaign_emptyAdditionalTargetings() {
        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithAdditionalTargetings(clientId, cid, null);
        bid = createInternalBanner(clientId, cid, pid);

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);

        Campaign campaign = sendNewCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    public void updateInternalFreeCampaign_emptyAdditionalTargetings() {
        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithAdditionalTargetings(clientId, cid,
                ADGROUP_ADDITIONAL_TARGETINGS_TEST_VALUES.keySet());
        bid = createInternalBanner(clientId, cid, pid);

        sendNewCampaign();

        //удаляем таргетинги
        dbSteps.adGroupsInternalSteps().deleteAdGroupAdditionalTargetings(Collections.singletonList(pid));
        dbSteps.campaignsSteps().setCampaignsStatusBsSynced(cid, CampaignsStatusbssynced.No);
        dbSteps.adGroupsSteps().setPhrasesStatusBsSynced(pid, PhrasesStatusbssynced.No);
        dbSteps.bannersSteps().setBannerStatusBsSynced(bid, BannersStatusbssynced.No);

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);

        Campaign campaign = sendSyncedCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }


    @Test
    public void updateInternalFreeCampaign_appendAdditionalTargetingsWithNullValues() {
        Long clientId =
                Long.valueOf(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(LOGIN).getClientID());
        pid = createInternalAdgroupsWithAdditionalTargetings(clientId, cid,
                ADGROUP_ADDITIONAL_TARGETINGS_TEST_VALUES.keySet());
        bid = createInternalBanner(clientId, cid, pid);
        sendNewCampaign();

        //добавляем таргетинги с пустым value
        appendAdditionalTargetings(pid, Arrays.asList(AdgroupAdditionalTargetingsTargetingType.is_mobile));
        dbSteps.campaignsSteps().setCampaignsStatusBsSynced(cid, CampaignsStatusbssynced.No);
        dbSteps.adGroupsSteps().setPhrasesStatusBsSynced(pid, PhrasesStatusbssynced.No);
        dbSteps.bannersSteps().setBannerStatusBsSynced(bid, BannersStatusbssynced.No);

        Context expectedContext =
                transportHelpSteps.buildExpectedContextInternalObjFromDb(pid, shard, UpdateInfo.UPDATE);

        Campaign campaign = sendSyncedCampaign();
        Context context = campaign != null ? campaign.getContext(pid) : null;

        assumeThat("в БК отправлена группа", context, notNullValue());
        assertThat("Значение параметров группы соответствует ожидаениям",
                context,
                beanDiffer(expectedContext).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
