package ru.yandex.autotests.directintapi.bstransport.main.internalads;

import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;


@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку внутренней рекламы через очередь полного реэкспорта (internal_free)")
@Features({FeatureNames.INTERNAL_ADS, FeatureNames.FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-94077")
public class InternalFreeFullExportTest extends InternalFullExportBaseTest {

    @Override
    CampaignTypeEnum getCampaignTypeEnum() {
        return CampaignTypeEnum.INTERNAL_FREE;
    }

    @Test
    public void createInternalFreeCampaign_commonCheck() {
        createCampaign_commonCheck();
    }

}
