package ru.yandex.autotests.directintapi.bstransport.main.internalads;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;

import ru.yandex.autotests.direct.cmd.rules.CampaignRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.httpclient.TestEnvironment;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.steps.ScriptParamsProfiles;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

public abstract class InternalFullExportBaseTest extends InternalAdsBaseTest {

    abstract CampaignTypeEnum getCampaignTypeEnum();

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CampaignRule campaignRule = new CampaignRule()
            .withMediaType(getCampaignTypeEnum())
            .withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(campaignRule);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
        dbSteps = TestEnvironment.newDbSteps().useShard(shard);
        transportHelpSteps = new TransportHelpSteps(api).useDbJooqSteps(dbSteps);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = campaignRule.getCampaignId();
        api.userSteps.campaignFakeSteps().makeCampaignInternalReadyForSendingToBS(cid);
    }

    protected void createCampaign_commonCheck() {
        TransportHelpSteps helpSteps = new TransportHelpSteps(api);
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);

        //имитируем постановку кампании в очередь скриптом bsFullLBExportMaster.pl
        api.userSteps.getDarkSideSteps().getBsExportSteps().addCampaignToFullExportQueue(cid);

        RunBsTransportScriptResponse resp = api.userSteps.transportSteps()
                .runBsClientDataScript(shard, cid, ScriptParamsProfiles.ProfileNames.FULL_EXPORT);

        assumeThat("в БК отправлена кампания", resp, notNullValue());
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);

        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assertThat("Значение параметров кампании соответствует ожидаениям",
                campaign,
                helpSteps.campaignReq1Matcher(expectedCampaign));
    }
}
