package ru.yandex.autotests.directintapi.bstransport.main.mcbanner.transmit;

import java.util.Arrays;
import java.util.Collection;

import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersMinusGeoType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersMinusGeoRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TestRegionsSet;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: применение минус-регионов, для ГО на поиске")
@Stories({StoriesNames.MCBANNER_ACTION_SEND, StoriesNames.MINUS_GEO})
@Features(FeatureNames.MCBANNER)
@Issue("https://st.yandex-team.ru/DIRECT-68242")
@RunWith(Parameterized.class)
public class BsTransportMcbannerWithMinusGeoTest {
    private static final String login = Logins.LOGIN_TRANSPORT_IMG_AD;
    private static int shard;
    private static Long cid;
    private static Long pid;
    private static Long bid;
    private static Context context;
    private static Banner banner;
    private static String imageHash;

    private static String defaultAdgroupSrcGeo = TestRegionsSet.defaultAdgroupSrcGeo;
    private static String defaultBannerCurentMinusGeo = TestRegionsSet.defaultBannerCurentMinusGeo;
    private static String defaultBannerBsSyncedMinusGeo = TestRegionsSet.defaultBannerBsSyncedMinusGeo;
    private static String adgroupGeoExceptCurrent = TestRegionsSet.adgroupGeoExceptCurrent;
    private static String adgroupGeoExceptBsSynced = TestRegionsSet.adgroupGeoExceptBsSynced;

    private static DirectJooqDbSteps dbSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public BannersStatuspostmoderate bannerStatusPostModerate;

    @Parameterized.Parameter(1)
    public ImagesStatusmoderate imageStatusModerate;

    @Parameterized.Parameter(2)
    public UpdateInfo resContextUpdateInfo;

    @Parameterized.Parameter(3)
    public UpdateInfo resBannerUpdateInfo;

    @Parameterized.Parameter(4)
    public StopFlag resBannerStop;

    @Parameterized.Parameter(5)
    public String resContextGeo;

    @Parameterized.Parameter(6)
    public String resBannerBsSyncedMinusGeo;

    @Parameterized.Parameters(name = "свойства группы/баннера: "
            + "bannerStatusPostModerate={0}, "
            + "imageStatusModerate={1}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(
                new Object[]{BannersStatuspostmoderate.Yes, ImagesStatusmoderate.Yes, UpdateInfo.UPDATE,
                        UpdateInfo.UPDATE, StopFlag.RESUME, adgroupGeoExceptCurrent, defaultBannerCurentMinusGeo},
                new Object[]{BannersStatuspostmoderate.No, ImagesStatusmoderate.Yes, UpdateInfo.UPDATE,
                        UpdateInfo.SKIP, StopFlag.RESUME, adgroupGeoExceptBsSynced, defaultBannerBsSyncedMinusGeo},
                new Object[]{BannersStatuspostmoderate.Yes, ImagesStatusmoderate.No, UpdateInfo.UPDATE,
                        UpdateInfo.SKIP, StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo}
        );
    }

    @BeforeClass
    @Step("Создаем новую кампанию, с группой и ГО-баннером, полностью модерируем и отправляем в БК")
    public static void beforeClass() {
        dbSteps = api.userSteps.getDirectJooqDbSteps();
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        imageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1); //240x400
        cid = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition()))));
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextImageAd(pid, imageHash);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setImageStatusModerate(bid, imageHash, ImagesStatusmoderate.Yes);

        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.MCBANNER);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(pid, PhrasesAdgroupType.mcbanner);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .setBannersBannerType(bid, BannersBannerType.mcbanner);

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен Banner графического баннера, первой итерацией", banner, IsNull.notNullValue());
    }

    @Before
    @Step("Применяем к созданным ранее группе/баннеру свойства из параметров теста, и запускаем итерацию транспорта")
    public void prepareTestData() {
        PhrasesRecord phrasesRecord = dbSteps.adGroupsSteps().getPhrases(pid)
                .setStatusbssynced(PhrasesStatusbssynced.No)
                .setGeo(defaultAdgroupSrcGeo);
        dbSteps.adGroupsSteps().updatePhrases(phrasesRecord);

        BannersRecord bannersRecord = dbSteps.bannersSteps().getBanner(bid)
                .setStatuspostmoderate(bannerStatusPostModerate)
                .setStatusbssynced(BannersStatusbssynced.No);
        dbSteps.bannersSteps().updateBanners(bannersRecord);

        dbSteps.imagesSteps().setImageStatusModerate(bid, imageHash, imageStatusModerate);

        dbSteps.bannersSteps().saveBannersMinusGeo(bid, BannersMinusGeoType.current, defaultBannerCurentMinusGeo);
        dbSteps.bannersSteps().saveBannersMinusGeo(bid, BannersMinusGeoType.bs_synced, defaultBannerBsSyncedMinusGeo);

        api.userSteps.campaignFakeSteps().setStatusBsSynced(cid, "No");
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;

    }

    @Test
    @Title("Отправка в БК группы баннеров с учетом минус-регионов, проверяем Context.UpdateInfo")
    public void testContextUpdateInfo() {
        if (resContextUpdateInfo == null) {
            assertThat("условия показа не отправлены в БК", context, nullValue());
        } else {
            assertThat("условия показа отправлены в БК", context, notNullValue());
            assertThat("условия показа отправлены в БК с соответствующим значением UpdateInfo",
                    context.getUpdateInfo(), equalTo(resContextUpdateInfo.value()));
        }
    }

    @Test
    @Title("Отправка в БК баннера с учетом минус-регионов, проверяем Banner.UpdateInfo")
    public void testBannerUpdateInfo() {
        if (resBannerUpdateInfo == null) {
            assertThat("баннер не отправлен в БК", banner, nullValue());
        } else {
            assumeThat("баннер отправлен в БК", banner, notNullValue());
            assertThat("баннер отправлен в БК с соответствующим значением UpdateInfo",
                    banner.getUpdateInfo(), equalTo(resBannerUpdateInfo.value()));
        }
    }

    @Test
    @Title("Отправка в БК баннера с учетом минус-регионов, проверяем Banner.Stop")
    public void testBannerStop() {
        if (resBannerStop != null) {
            assumeThat("баннер отправлен в БК", banner, notNullValue());
            assertThat("баннер отправлен в БК с соответствующим значением Stop",
                    banner.getStop(), equalTo(resBannerStop.value()));
        }
    }

    @Test
    @Title("Отправка в БК группы баннеров с учетом минус-регионов, проверяем Context.Geo")
    public void testContextGeo() {
        if (resContextGeo != null) {
            assumeThat("условия показа отправлены в БК", context, notNullValue());
            String[] resContextGeoList;
            if (resContextGeo.equals("")) {
                resContextGeoList = new String[]{};
            } else {
                resContextGeoList = resContextGeo.split(",");
            }
            assertThat("условия показа отправлены в БК с соответствующим значением Geo",
                    context.getGeo(), containsInAnyOrder(resContextGeoList));
        }
    }

    @Test
    @Title("Отправка в БК баннера с учетом минус-регионов, проверяем состояние записи в БД banners_minus_geo[type=bs_synced]")
    public void testBannerBsSyncedMinusGeo() {
        BannersMinusGeoRecord minusGeo = dbSteps.bannersSteps().getBannersMinusGeo(bid, BannersMinusGeoType.bs_synced);
        if (resBannerBsSyncedMinusGeo == null) {
            assertThat("баннер после отправки в БК, в БД находится с соответствующими минус-регионами типа bs_synced",
                    minusGeo, nullValue());
        } else {
            assertThat("баннер после отправки в БК, в БД находится с соответствующими минус-регионами типа bs_synced",
                    minusGeo == null ? null : minusGeo.getMinusGeo(), equalTo(resBannerBsSyncedMinusGeo));
        }
    }

}
