package ru.yandex.autotests.directintapi.bstransport.main.mcbanner.transmit;

import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesFormatsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Resources;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title(" Отправка поля Banner.MediaImage и Banner.Resources.MediaImage для ГО на поиске")
@Stories(StoriesNames.MCBANNER_ACTION_SEND)
@Features(FeatureNames.MCBANNER)
@Issue("https://st.yandex-team.ru/DIRECT-68242")
public class BsTransportNewMcbannerMediaImageTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;

    public CampaignType campaignType;

    public AdGroupType adGroupType;

    public String imageHash;

    private Banner banner;
    private String[] expectedMediaImage;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        String imageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1); //240x400
        Long cid = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition()))));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextImageAd(pid, imageHash);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setImageStatusModerate(bid, imageHash, ImagesStatusmoderate.Yes);

        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.MCBANNER);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(pid, PhrasesAdgroupType.mcbanner);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .setBannersBannerType(bid, BannersBannerType.mcbanner);

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен графический баннер", banner, notNullValue());
        BannerImagesFormatsRecord bannerImagesFormatsRecord = api.userSteps.getDirectJooqDbSteps()
                .useShard(shard).imagesSteps().getBannerImagesFormatsRecords(imageHash);
        assumeThat("по хэшу нашлась запись", bannerImagesFormatsRecord, Matchers.notNullValue());

        expectedMediaImage = getExpectedMediaImage(bannerImagesFormatsRecord);
    }

    private String[] getExpectedMediaImage(BannerImagesFormatsRecord bannerImagesFormatsRecord) {
        String mdsUrl = new StringBuilder().append("//")
                .append(bannerImagesFormatsRecord.getAvatarsHost().getLiteral())
                .append("/get-")
                .append(bannerImagesFormatsRecord.getNamespace().getLiteral())
                .append("/")
                .append(bannerImagesFormatsRecord.getMdsGroupId()).append("/")
                .append(bannerImagesFormatsRecord.getImageHash())
                .append("/orig")
                .toString();

        return
                new String[]{
                        mdsUrl,
                        String.valueOf(bannerImagesFormatsRecord.getWidth()),
                        String.valueOf(bannerImagesFormatsRecord.getHeight())
                };
    }

    @Test
    @Title("Проверяем параметры отправляемого графического баннера")
    @Description("Проверяем следующие параметры на уровне баннера: IsMediaImage, MediaImage, TemplateID, Resources->MediaImage")
    public void testSendingToBsBannerMediaImage() {
        Banner expectedBanner = new Banner()
                .withIsMediaImage(1)
                .withMediaImage(expectedMediaImage)
                .withResources(new Resources().withMediaImage(expectedMediaImage))
                .withTemplateId(BannerTemplateId.MEDIA_IMAGE_TEMPLATE_ID.value());

        assertThat("параметры графического баннера соотв. ожиданиям",
                banner,
                beanDiffer(expectedBanner).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}

