package ru.yandex.autotests.directintapi.bstransport.main.offerretargeting.parameters;

import java.math.BigDecimal;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.BidsBaseSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.OfferRetargeting;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Description("Транспорт: проверка отправки в БК ставок в офферном ретаргетинге")
@Features({FeatureNames.OFFER_RETARGETING})
@Issue("https://st.yandex-team.ru/DIRECT-158191")
public class OfferRetargetingPricesTest {
    private static final String login = Logins.LOGIN_TRANSPORT_RM2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private static BidsBaseSteps bidsBaseSteps;
    private static final Money PRICE = MoneyCurrency.get(Currency.RUB).getMinPrice().multiply(5L);
    private static final Money PRICE_CONTEXT = MoneyCurrency.get(Currency.RUB).getMinPrice().multiply(4L);
    private static final TextCampaignSearchStrategyAddMap strategy =
            new TextCampaignSearchStrategyAddMap().defaultHighestPosition();

    private OfferRetargeting offerRetargeting;
    private Long offerRetargetingId;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        bidsBaseSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsBaseSteps();
    }

    @Before
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaignWithSearchStrategy(strategy);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        BigDecimal savedPriceContext = PRICE_CONTEXT.bigDecimalValue();
        offerRetargetingId = bidsBaseSteps
                .saveDefaultOfferRetargeting(cid, pid, PRICE.bigDecimalValue(), savedPriceContext);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse
                resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        offerRetargeting = context != null ? context.getOfferRetargeting(offerRetargetingId) : null;

        assumeThat("в БК отправлен офферный таргетинг", offerRetargeting, notNullValue());
    }

    @Test
    public void checkPriceAndCurrencyISOCode() {
        OfferRetargeting expectedOfferRetargeting = new OfferRetargeting()
                .withEid(offerRetargetingId.toString())
                .withPrice(PRICE.doubleValue())
                .withPriceContext(PRICE_CONTEXT.doubleValue())
                .withCurrencyIsoCode(Currency.RUB.getIsoCode());
        assertThat("отправился правильный бесфразный таргетинг", offerRetargeting,
                beanDiffer(expectedOfferRetargeting).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
