package ru.yandex.autotests.directintapi.bstransport.main.performance;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 08.10.2015
 * https://st.yandex-team.ru/TESTIRT-7394
 * https://st.yandex-team.ru/TESTIRT-10194
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Features({FeatureNames.SMART_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-44221")
@Title("Изменение статуса синхронизации с БК при отправке перформансов")
public class BsTransportOfPerformanceStatusBSSyncedTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    @ClassRule
    public static DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static int shard;
    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, bannersRule.getCampaignId());
    }

    @Test
    public void testPerformanceCampaignsStatusBsSyncedAfterSync() {
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(bannersRule.getCampaignId());
        assertThat("после отправки в БК у кампании верный statusBsSynced", campaigns.getStatusbssynced()
                , equalTo(CampaignsStatusbssynced.Yes));
    }

    @Test
    public void testPerformanceGroupStatusBsSyncedAfterSync() {
        PhrasesRecord phrasesRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupsSteps().getPhrases(bannersRule.getGroupId());
        assertThat("после отправки в БК у группы верный statusBsSynced", phrasesRecord.getStatusbssynced()
                , equalTo(PhrasesStatusbssynced.Yes));
    }

    @Test
    public void testPerformanceBannerStatusBsSyncedAfterSync() {
        BannersRecord banners = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .getBanner(bannersRule.getBannerId());
        assertThat("после отправки в БК у баннера верный statusBsSynced", banners.getStatusbssynced(),
                equalTo(BannersStatusbssynced.Yes));
    }
}
