package ru.yandex.autotests.directintapi.bstransport.main.performance.banner;

import com.google.gson.Gson;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.GroupParamsRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.HrefOpeningParams;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataPerformance;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.isEmptyString;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 10.12.2015
 * https://st.yandex-team.ru/TESTIRT-7968
 * https://st.yandex-team.ru/TESTIRT-10194
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-49246")
@Title("Транспорт: проверка отправки в БК BannerLandData для перф. баннера. Поле HrefParams, раскрытие")
@Features(FeatureNames.SMART_BANNERS)
public class BsTransportOfPerformanceBannerLandDataHrefParamsOpenningTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static int shard;
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    @Rule
    public Trashman trashman = new Trashman(api);
    private Banner banner;
    private String hrefParams;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Step("Подготовка данных для теста")
    @Before
    public void before() {
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        hrefParams = String
                .format("value={%s}&value1={%s}&value2={%s}&value3={%s}&value4={%s}&value5={%s}"
                        , HrefOpeningParams.CAMPAIGN_ID
                        , HrefOpeningParams.ADGROUP_ID
                        , HrefOpeningParams.CAMPAIGNID
                        , HrefOpeningParams.ADGROUPID
                        , HrefOpeningParams.CAMPAIGN_TYPE
                        , HrefOpeningParams.CAMPAIGNTYPE);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().saveGroupParams(
                new GroupParamsRecord()
                        .setPid(bannersRule.getGroupId())
                        .setHasPhraseidHref(1)
                        .setHrefParams(hrefParams)
        );

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        banner = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId()).getContext(bannersRule.getGroupId()).getBanner(bannersRule.getBannerId());
    }

    @Test
    @Title("Отправка в БК BannerLandData для перф. баннера")
    public void testBannerLandData() {
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("UpdateInfo отправленного баннера " + UpdateInfo.UPDATE
                , banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assumeThat("отправленное поле BannerLandData не пустое", banner.getBannerLandData(), not(isEmptyString()));

        BannerLandDataPerformance bannerLandDataPerformance = new Gson().fromJson(banner.getBannerLandData()
                , BannerLandDataPerformance.class);
        assertThat("отправленное в БК поле BannerLandData.HrefParams соответствуют ожидаемому",
                bannerLandDataPerformance.getHrefParams(), equalTo(hrefParams
                        .replace(HrefOpeningParams.CAMPAIGNID.getParamName(), bannersRule.getCampaignId().toString())
                        .replace(HrefOpeningParams.CAMPAIGN_ID.getParamName(), bannersRule.getCampaignId().toString())
                        .replace(HrefOpeningParams.ADGROUPID.getParamName(), bannersRule.getGroupId().toString())
                        .replace(HrefOpeningParams.ADGROUP_ID.getParamName(), bannersRule.getGroupId().toString())
                        .replace(HrefOpeningParams.CAMPAIGN_TYPE.getParamName(), CampaignsType.PERFORMANCE.type())
                        .replace(HrefOpeningParams.CAMPAIGNTYPE.getParamName(), CampaignsType.PERFORMANCE.type())
                        .replaceAll("\\{", "")
                        .replaceAll("\\}", "")));
    }
}
