package ru.yandex.autotests.directintapi.bstransport.main.performance.banner;

import java.util.HashMap;
import java.util.Map;

import com.google.gson.Gson;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.HrefMacrosDMO;
import ru.yandex.autotests.directapi.darkside.model.HrefOpeningParams;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataPerformance;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 22.03.2016
 * https://st.yandex-team.ru/TESTIRT-8819
 * https://st.yandex-team.ru/TESTIRT-10194
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Stories(StoriesNames.PERF_BANNER_ACTION_CREATION)
@Features(FeatureNames.SMART_BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-51675")
public class BsTransportOfPerformanceBannerLandDataSubstituteURLParamsTest {

    private static final String URL_PARAMS_CAMPAIGN_NAME = "%D0%9D%D0%BE%D0%B2%D0%B0%D1%8F%20%D0%BA%D0%B0%D0%BC%D0%BF%D0%B0%D0%BD%D0%B8%D1%8F%2C%20%D1%81%D0%BE%D0%B7%D0%B4%D0%B0%D0%BD%D0%BD%D0%B0%D1%8F%20%D1%81%20%D0%BF%D0%BE%D0%BC%D0%BE%D1%89%D1%8C%20java%20http%20client";
    private static final String URL_PARAMS_CAMPAIGN_NAME_LAT = "Novaya_kampaniya__sozdannaya_s_pomoshch_java_http_client";
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    private static int shard;
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    @Rule
    public Trashman trashman = new Trashman(api);
    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private Banner banner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        banner = context != null ? context.getBanner(bannersRule.getBannerId()) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    public void performanceCreativeTest() {
        assumeThat("в БК отпралено поле BannerLandData", banner.getBannerLandData(), notNullValue());
        BannerLandDataPerformance bannerLandData = new Gson().fromJson(banner.getBannerLandData()
                , BannerLandDataPerformance.class);
        assertThat("в БК на уровне BANNER отправилось поле BannerLandData с SubstituteURLParams"
                , bannerLandData.getSubstituteURLParams()
                , notNullValue());
        Map<String, String> expectedSubstituteURLParams = new HashMap<>();
        for (HrefMacrosDMO hrefMacrosDMO : HrefMacrosDMO.values()) {
            expectedSubstituteURLParams
                    .put("{" + hrefMacrosDMO.getValue() + "}", "{" + hrefMacrosDMO.getMacros() + "}");
        }
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.ADGROUP_ID.getParamName() + "}",
                bannersRule.getGroupId().toString());
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.ADGROUPID.getParamName() + "}",
                bannersRule.getGroupId().toString());
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGN_TYPE.getParamName() + "}",
                CampaignsType.PERFORMANCE.type());
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGNTYPE.getParamName() + "}",
                CampaignsType.PERFORMANCE.type());
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGN_ID.getParamName() + "}",
                bannersRule.getCampaignId().toString());
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGNID.getParamName() + "}",
                bannersRule.getCampaignId().toString());
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGN_NAME.getParamName() + "}",
                URL_PARAMS_CAMPAIGN_NAME);
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGNNAME.getParamName() + "}",
                URL_PARAMS_CAMPAIGN_NAME);
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGN_NAME_LAT.getParamName() + "}",
                URL_PARAMS_CAMPAIGN_NAME_LAT);
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGNNAMELAT.getParamName() + "}",
                URL_PARAMS_CAMPAIGN_NAME_LAT);
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGN_CURRENCY.getParamName() + "}", "RUB");
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGNCURRENCY.getParamName() + "}", "RUB");
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGN_CURRENCY_CODE.getParamName() + "}", "643");
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGNCURRENCYCODE.getParamName() + "}", "643");
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGN_COST_TYPE.getParamName() + "}","CPC");
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGNCOSTTYPE.getParamName() + "}", "CPC");
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGN_COST.getParamName() + "}", "4");
        expectedSubstituteURLParams.put("{" + HrefOpeningParams.CAMPAIGNCOST.getParamName() + "}", "4");
        assertThat("", bannerLandData.getSubstituteURLParams(), beanDiffer(expectedSubstituteURLParams));
    }
}
