package ru.yandex.autotests.directintapi.bstransport.main.performance.banner;

import com.google.gson.Gson;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceNowOptimizingBy;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceTargetFunnel;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsPerformanceRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.*;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.*;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 27.01.2016
 * https://st.yandex-team.ru/TESTIRT-8347
 * https://st.yandex-team.ru/TESTIRT-8690
 * https://st.yandex-team.ru/TESTIRT-10194
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Features(FeatureNames.SMART_BANNERS)
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-50287")
        , @Issue("https://st.yandex-team.ru/DIRECT-50492")})
@Title("Отправка в БК поля TargetParams feed'а в BannerLandData")
public class BsTransportOfPerformanceBannerLandDataTargetsParamsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    private static int shard;
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    @Rule
    public Trashman trashman = new Trashman(api);
    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private Banner banner;
    private BidsPerformanceRecord firstBidsPerformance;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        firstBidsPerformance = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps().getBidsPerformanceByPid(bannersRule.getGroupId()).get(0);
    }

    @Test
    @Description("Отправка фильтра без ретаргетинга: " +
            "проверяем, что BannerLandData.TargetParams содержит только target_funnel")
    public void performanceBannerLandDataWithSingleTargetsParamsWithoutRetargeting() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        banner = context != null ? context.getBanner(bannersRule.getBannerId()) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("в БК отпралено поле BannerLandData", banner.getBannerLandData(), notNullValue());
        TargetsParamsPerformance expected = new TargetsParamsPerformance();

        expected.setTargetFunnel(firstBidsPerformance.getTargetFunnel().getLiteral());
        expected.setGoalContextId(null);
        BannerLandDataPerformance bannerLandData = new Gson().fromJson(banner.getBannerLandData()
                , BannerLandDataPerformance.class);
        assumeThat("в БК на уровне BANNER отправилось поле BannerLandData с TargetsParams"
                , bannerLandData.getTargetsParams()
                , notNullValue());
        assertThat("структура BannerLandData.TargetParams соответсвует ожиданиям"
                , bannerLandData.getTargetsParams().get(firstBidsPerformance.getPerfFilterId().toString())
                , beanDiffer(expected));
    }

    @Test
    @Description("Отправка фильтра с ретаргетингом:" +
            "проверяем, что BannerLandData.TargetParams содержит поля goal_context_id, target_funnel")
    public void performanceBannerLandDataWithSingleTargetsParamsWithRetargeting() {
        Long retCondId = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN).get(0);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps().updateBidsPerformance(firstBidsPerformance.setRetCondId(retCondId));
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        banner = context != null ? context.getBanner(bannersRule.getBannerId()) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("в БК отпралено поле BannerLandData", banner.getBannerLandData(), notNullValue());

        TargetsParamsPerformance expected = new TargetsParamsPerformance();
        expected.setTargetFunnel(firstBidsPerformance.getTargetFunnel().getLiteral());
        expected.setGoalContextId(retCondId);
        BannerLandDataPerformance bannerLandData = new Gson().fromJson(banner.getBannerLandData()
                , BannerLandDataPerformance.class);
        assumeThat("в БК на уровне BANNER отправилось поле BannerLandData с TargetsParams"
                , bannerLandData.getTargetsParams()
                , notNullValue());
        assertThat("структура BannerLandData.TargetParams соответсвует ожиданиям"
                , bannerLandData.getTargetsParams().get(firstBidsPerformance.getPerfFilterId().toString())
                , beanDiffer(expected));
    }

    @Test
    @Description("Отправка 2х фильров без ретаргетига: " +
            "проверяем, что BannerLandData.TargetParams содержит только target_funnel")
    public void performanceBannerLandDataWithTwoTargetsParams() {
        Long bidsPerformanceId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps()
                .saveDefaultBidsPerformance(bannersRule.getGroupId(), BidsPerformanceNowOptimizingBy.CPA);
        BidsPerformanceRecord secondBidsPerformance = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps().getBidsPerformance(bidsPerformanceId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsPerformanceSteps().updateBidsPerformance(
                firstBidsPerformance.setTargetFunnel(BidsPerformanceTargetFunnel.product_page_visit)
        );
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsPerformanceSteps().updateBidsPerformance(
                secondBidsPerformance.setTargetFunnel(BidsPerformanceTargetFunnel.same_products)
        );
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        banner = context != null ? context.getBanner(bannersRule.getBannerId()) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("в БК отпралено поле BannerLandData", banner.getBannerLandData(), notNullValue());

        BannerLandDataPerformance bannerLandData = new Gson().fromJson(banner.getBannerLandData()
                , BannerLandDataPerformance.class);

        TargetsParamsPerformance expectedTargetsParams1 = new TargetsParamsPerformance();
        expectedTargetsParams1.setTargetFunnel(firstBidsPerformance.getTargetFunnel().getLiteral());
        expectedTargetsParams1.setGoalContextId(null);

        TargetsParamsPerformance expectedTargetsParams2 = new TargetsParamsPerformance();
        expectedTargetsParams2.setTargetFunnel(secondBidsPerformance.getTargetFunnel().getLiteral());
        expectedTargetsParams2.setGoalContextId(null);

        assumeThat("в БК на уровне BANNER отправилось поле BannerLandData с TargetsParams"
                , bannerLandData.getTargetsParams()
                , notNullValue());
        assumeThat("в БК на уровне BANNER отправилось поле BannerLandData с правильным количеством TargetsParams"
                , bannerLandData.getTargetsParams().size()
                , equalTo(2));

        assertThat("в БК на уровне BANNER отправилось поле BannerLandData с не пустыми Targets"
                , bannerLandData.getTargetsParams().get(firstBidsPerformance.getPerfFilterId().toString())
                , beanDiffer(expectedTargetsParams1));
        assertThat("структура BannerLandData.TargetParams соответсвует ожиданиям"
                , bannerLandData.getTargetsParams().get(secondBidsPerformance.getPerfFilterId().toString())
                , beanDiffer(expectedTargetsParams2));
    }
}
