package ru.yandex.autotests.directintapi.bstransport.main.performance.banner;

import com.google.gson.Gson;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceTargetFunnel;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsPerformanceRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataPerformance;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 09.03.2016
 * https://st.yandex-team.ru/TESTIRT-8347
 * https://st.yandex-team.ru/TESTIRT-10194
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Features(FeatureNames.SMART_BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-50492")
@RunWith(Parameterized.class)
public class BsTransportOfPerformanceBannerLandDataWithSingleTargetsParamsTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    private static int shard;
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter(0)
    public BidsPerformanceTargetFunnel targetFunnel;
    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private TransportSteps transportSteps = new DarkSideSteps().getTransportSteps();
    private Banner banner;
    private BidsPerformanceRecord bidsPerformance;

    @Parameterized.Parameters(name = "Target funnel - {0}")
    public static Iterable<Object[]> data() {
        return Stream.of(BidsPerformanceTargetFunnel.values())
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        bidsPerformance = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps().getBidsPerformanceByPid(bannersRule.getGroupId()).get(0)
                .setTargetFunnel(targetFunnel);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps().updateBidsPerformance(bidsPerformance);
        RunBsTransportScriptResponse resp = transportSteps.sendNewCampaign(shard, bannersRule.getCampaignId());
        Campaign campaign = transportSteps.getClientDataRequestCampaign(resp, 0, bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        banner = context != null ? context.getBanner(bannersRule.getBannerId()) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("в БК отпралено поле BannerLandData", banner.getBannerLandData(), notNullValue());
    }

    @Test
    public void performanceBannerLandDataWithSingleTargetsParams() {
        BannerLandDataPerformance bannerLandData = new Gson().fromJson(banner.getBannerLandData()
                , BannerLandDataPerformance.class);
        assumeThat("в БК на уровне BANNER отправилось поле BannerLandData с TargetsParams"
                , bannerLandData.getTargetsParams()
                , notNullValue());
        assertThat("в БК на уровне BANNER отправилось поле BannerLandData с не пустыми Targets"
                , bannerLandData.getTargetsParams().get(bidsPerformance.getPerfFilterId().toString()).getTargetFunnel()
                , equalTo(targetFunnel.getLiteral()));
    }
}
