package ru.yandex.autotests.directintapi.bstransport.main.performance.banner;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.GroupParamsRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.HrefOpeningParams;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.isEmptyString;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 06.04.16.
 * https://st.yandex-team.ru/TESTIRT-8695
 * https://st.yandex-team.ru/TESTIRT-10194
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-51468")
@Description("Транспорт: отправка в БК поля Resources.ClickUrlTail на уровне CONTEXT;" +
        "проверяем подстановку в параметры идентификаторов Директа")
@Features(FeatureNames.SMART_BANNERS)
public class BsTransportOfPerformanceClickUrlTailSubstitutionTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static int shard;
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    @Rule
    public Trashman trashman = new Trashman(api);
    private Context context;
    private String actualClickUrlTailParams;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Step("Подготовка данных для теста")
    @Before
    public void before() {
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        actualClickUrlTailParams = String
                .format("value0={%s}&value1={%s}&value2={%s}&value3={%s}&value4={%s}&value5={%s}"
                        , HrefOpeningParams.CAMPAIGNID.getParamName()
                        , HrefOpeningParams.CAMPAIGN_ID.getParamName()
                        , HrefOpeningParams.ADGROUPID.getParamName()
                        , HrefOpeningParams.ADGROUP_ID.getParamName()
                        , HrefOpeningParams.CAMPAIGN_TYPE.getParamName()
                        , HrefOpeningParams.CAMPAIGNTYPE.getParamName());

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().saveGroupParams(
                new GroupParamsRecord()
                        .setHrefParams(actualClickUrlTailParams)
                        .setHasPhraseidHref(1)
                        .setPid(bannersRule.getGroupId())
        );

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        assumeThat("в БК отправлен CONTEXT", context, notNullValue());
    }

    @Test
    @Description("Проверяем, что в ClickUrlTail отправляется на уровне CONTEXT")
    public void testClickUrlTailInContext() {
        assumeThat("UpdateInfo отправленного контекста " + UpdateInfo.UPDATE
                , context.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assumeThat("поле CONTEXT.Resource.ClickUrlTail не пустое", context.getResources().getClickUrlTail(), not(isEmptyString()));

        String expectedClickUrlTailParams = actualClickUrlTailParams
                .replace(HrefOpeningParams.CAMPAIGNID.getParamName(), bannersRule.getCampaignId().toString())
                .replace(HrefOpeningParams.CAMPAIGN_ID.getParamName(), bannersRule.getCampaignId().toString())
                .replace(HrefOpeningParams.ADGROUPID.getParamName(), bannersRule.getGroupId().toString())
                .replace(HrefOpeningParams.ADGROUP_ID.getParamName(), bannersRule.getGroupId().toString())
                .replace(HrefOpeningParams.CAMPAIGN_TYPE.getParamName(), CampaignsType.PERFORMANCE.type())
                .replace(HrefOpeningParams.CAMPAIGNTYPE.getParamName(), CampaignsType.PERFORMANCE.type())
                .replaceAll("\\{", "")
                .replaceAll("\\}", "");

        assertThat("отправленное в БК поле Resource.ClickUrlTail соответсвует ожиданиям",
                context.getResources().getClickUrlTail(), equalTo(expectedClickUrlTailParams));
    }
}
