package ru.yandex.autotests.directintapi.bstransport.main.performance.banner;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersPerformanceRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.*;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.List;

import static org.hamcrest.Matchers.iterableWithSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 08.10.2015
 * https://st.yandex-team.ru/TESTIRT-7394
 * https://st.yandex-team.ru/TESTIRT-10194
 * https://st.yandex-team.ru/TESTIRT-10837
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Stories(StoriesNames.PERF_BANNER_ACTION_CREATION)
@Features(FeatureNames.BANNERS)
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-44221"),
        @Issue("https://st.yandex-team.ru/DIRECT-60917")})
@Title("Отправка в БК полей характерных для perfomance")
public class BsTransportOfPerformanceCreativeTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);

    private static int shard;

    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private Banner banner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        banner = context != null ? context.getBanner(bannersRule.getBannerId()) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Проверяем что смарт-баннер содержит корректные поля")
    @Description("проверяем в баннере корректность следующих полей: CreativeID, TemplateID")
    public void performanceCreativeTest() {
        List<BannersPerformanceRecord> bannersPerformances = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersPerformanceSteps().findBannersPerformance(bannersRule.getBannerId());
        assumeThat("в таблице ppc.banners_performance нашли ровно 1 запись с bid = " + bannersRule.getBannerId()
                , bannersPerformances, iterableWithSize(1));

        Banner expectedBanner = new Banner()
                .withCreative(Arrays.asList(bannersPerformances.get(0).getCreativeId().longValue()))
                .withTemplateId(BannerTemplateId.PERFOMANCE_PARENT_TEMPLATE_ID);

        assertThat("в БК на уровне BANNER отправилось правильное поле Creative"
                , banner
                , beanDiffer(expectedBanner)
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
