package ru.yandex.autotests.directintapi.bstransport.main.performance.banner;

import java.util.Arrays;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersPerformanceRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.iterableWithSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 08.10.2015
 * https://st.yandex-team.ru/TESTIRT-7394
 * https://st.yandex-team.ru/TESTIRT-10194
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Stories(StoriesNames.PERF_BANNER_ACTION_CREATION)
@Features(FeatureNames.BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-44221")
@Title("Отправка в БК полей характерных для perfomance")
public class BsTransportOfPerformanceCreativeTwoBannersTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);

    @ClassRule
    public static DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static int shard;
    private static Banner banner;
    private static Banner bannerAnother;
    private static Long bid;
    private static Long bidAnother;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);
        bid = bannersRule.getBannerId();
        bidAnother = helpSteps.addAndAcceptAnotherPerformanceBanner(LOGIN, bannersRule, shard);
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        banner = context != null ? context.getBanner(bid) : null;
        bannerAnother = context != null ? context.getBanner(bidAnother) : null;
        assumeThat("в БК отправлен первый баннер", banner, notNullValue());
        assumeThat("в БК отправлен второй баннер", bannerAnother, notNullValue());
    }

    @Test
    public void performanceCreativeFirstBannerTest() {
        List<BannersPerformanceRecord> bannersPerformances = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersPerformanceSteps().findBannersPerformance(bid);
        assumeThat("в таблице ppc.banners_performance нашли ровно 1 запись с bid = " + bid
                , bannersPerformances, iterableWithSize(1));
        assertThat("в БК на уровне BANNER отправилось правильное поле Creative"
                , banner.getCreative()
                , equalTo(Arrays.asList(bannersPerformances.get(0).getCreativeId().longValue())));
    }

    @Test
    public void performanceCreativeSecondBannerTest() {
        List<BannersPerformanceRecord> bannersPerformances = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersPerformanceSteps().findBannersPerformance(bidAnother);
        assumeThat("в таблице ppc.banners_performance нашли ровно 1 запись с bid = " + bidAnother
                , bannersPerformances, iterableWithSize(1));
        assertThat("в БК на уровне BANNER отправилось правильное поле Creative"
                , bannerAnother.getCreative()
                , equalTo(Arrays.asList(bannersPerformances.get(0).getCreativeId().longValue())));
    }

}
