package ru.yandex.autotests.directintapi.bstransport.main.performance.banner;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.CreativeWithStatus;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@SuppressWarnings("FieldCanBeLocal")
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Отправка баннера с типом performance-tgo")
public class BsTransportOfPerformanceCreativeType {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule()
            .withUlogin(LOGIN);

    @ClassRule
    public static DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static int shard;
    private static CreativeWithStatus creativeWithStatus;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long bid = bannersRule.getBannerId();
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);
        helpSteps.addAndAcceptPerformanceTGOGroupWithBanner(LOGIN, bannersRule, shard);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        creativeWithStatus = banner != null ? banner.getCreativeWithStatus().get(0) : null;
        assumeThat("creativeWithStatus отправлен", creativeWithStatus, notNullValue());
    }

    @Test
    public void sendPerformanceTGOCreative() {
        assertThat("correct CreativeType", creativeWithStatus.getCreativeType(),
                equalTo(CreativeWithStatus.CreativeType.PERFORMANCE_TGO.toString()));
    }

}
