package ru.yandex.autotests.directintapi.bstransport.main.performance.banner;

import java.util.Arrays;
import java.util.Collection;

import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Stories(StoriesNames.PERF_BANNER_ACTION_CREATION)
@Features(FeatureNames.BANNERS)
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-165801")})
@Title("Отправка в БК языка performance-баннера")
@RunWith(Parameterized.class)
public class BsTransportOfPerformanceLangTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);

    private static final PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    private static int shard;
    private final TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public BannerLanguage language;

    @Parameterized.Parameter(2)
    public boolean createWithMainBanner;

    @Parameterized.Parameter(3)
    public Matcher<String> matcher;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {"Язык не выставлен, не отправляется на родительском баннере", null, true, nullValue()},
                {"Язык — русский, не отправляется на родительском баннере", BannerLanguage.RUSSIAN, true, nullValue()},
                {"Язык — английский, отправляется на родительском баннере", BannerLanguage.ENGLISH, true,
                        is(BannerLanguage.ENGLISH.transportValue())},
                {"Язык — казахский, отправляется на родительском баннере", BannerLanguage.KAZAKH, true,
                        is(BannerLanguage.KAZAKH.transportValue())},
                {"Язык не выставлен, не отправляется на классическом баннере", null, false, nullValue()},
                {"Язык — русский, не отправляется на классическом баннере", BannerLanguage.RUSSIAN, false, nullValue()},
                {"Язык — английский, отправляется на классическом баннере", BannerLanguage.ENGLISH, false,
                        is(BannerLanguage.ENGLISH.transportValue())},
        };
        return Arrays.asList(data);
    }


    private Banner banner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        if (createWithMainBanner) {
            helpSteps.makeCampWithPerformanceMainBannerReadyForSendingToBS(bannersRule, shard);
        } else {
            helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);
        }

        if (language != null) {
            api.userSteps.getDirectJooqDbSteps()
                    .useShard(shard)
                    .campaignsSteps()
                    .setCampOptionsContentLang(bannersRule.getCampaignId(), language.dbValue());
        }

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, bannersRule.getCampaignId());

        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        banner = context != null ? context.getBanner(bannersRule.getBannerId()) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Проверяем что отправленный смарт-баннер содержит корректное поле Lang")
    public void performanceBannerTest() {
        assertThat(banner.getLang(), matcher);
    }
}
