package ru.yandex.autotests.directintapi.bstransport.main.performance.context.filter;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsPerformanceRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.web.api.core.DirectRule;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Filter;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 14.03.2016
 * https://st.yandex-team.ru/TESTIRT-8690
 * https://st.yandex-team.ru/TESTIRT-10194
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Features(FeatureNames.SMART_BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-50287")
public class BsTransportOfPerformanceFilterAudienceRetargetingTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    private static int shard;
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    @Rule
    public DirectRule directRule = DirectRule.defaultRule().as(LOGIN);
    @Rule
    public Trashman trashman = new Trashman(api);

    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private Filter filter;
    private long retargetingCondId;

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        helpSteps.useDirectWebApiSteps(directRule.webApiSteps());
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);
        List<RetargetingGoal> segmentGoals = api.userSteps.retargetingSteps()
                .getRetargetingGoals(RetargetingGoalType.AUDIENCE_SEGMENT, LOGIN);

        long[] goalIds = segmentGoals.stream().mapToLong(RetargetingGoal::getGoalID).toArray();
        retargetingCondId = api.userSteps.retargetingListsSteps()
                .addRandomRetargetingList(LOGIN, goalIds);
        assumeThat("добавился ретаргетинг", retargetingCondId,  notNullValue());
        BidsPerformanceRecord filterDb = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsPerformanceSteps()
                .getBidsPerformanceByPid(bannersRule.getGroupId()).get(0)
                .setRetCondId((long) retargetingCondId);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsPerformanceSteps().updateBidsPerformance(filterDb);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        assumeThat("в БК отправился CONTEXT"
                , context, notNullValue());
        filter = context.getFilter(filterDb.getPerfFilterId().intValue());
        assumeThat("в БК на уровне CONTEXT отправился FILTER для pid=" + bannersRule.getGroupId()
                , filter, notNullValue());
    }

    @Test
    @Description("Проверяем, что на уровне FILTER отправляется правильный GOAL_CONTEXT " +
            "в случае ретаргетинга по сегментам Аудитории ")
    public void performanceContextFilterGoalContext() {
        GoalContext expected = new GoalContext();
        expected.setExpression(helpSteps.getRetConditionsBSStyle(retargetingCondId));
        expected.setId(String.valueOf(retargetingCondId));
        assertThat("в БК отправлено правильное поле FILTER.GOAL_CONTEXT",
                filter.getGoalContext(String.valueOf(retargetingCondId)), beanDiffer(expected));
    }
}
