package ru.yandex.autotests.directintapi.bstransport.main.performance.context.filter;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceTargetFunnel;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsPerformanceRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Filter;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 08.10.2015
 * https://st.yandex-team.ru/TESTIRT-7394
 * https://st.yandex-team.ru/TESTIRT-10194
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Features(FeatureNames.SMART_BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-44221")
@RunWith(Parameterized.class)
public class BsTransportOfPerformanceFilterOnlyOfferRetargetingTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);

    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter(0)
    public BidsPerformanceTargetFunnel targetFunnel;
    @Parameterized.Parameter(1)
    public int onlyOfferRetargeting;
    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private Filter filter;

    @Parameterized.Parameters()
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {BidsPerformanceTargetFunnel.product_page_visit, 1},
                {BidsPerformanceTargetFunnel.same_products, 0}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        BidsPerformanceRecord bidsPerformance = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps().getBidsPerformanceByPid(bannersRule.getGroupId()).get(0);
        assumeThat("в базе найден BidsPerformance", bidsPerformance, notNullValue());
        bidsPerformance.setTargetFunnel(targetFunnel);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps().updateBidsPerformance(bidsPerformance);
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        Context context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        assumeThat("в БК отправился CONTEXT"
                , context, notNullValue());
        filter = context.getFilter(bidsPerformance.getPerfFilterId().intValue());
        assumeThat("в БК на уровне CONTEXT отправился FILTER для pid=" + bannersRule.getGroupId()
                , filter, notNullValue());
    }

    @Test
    public void performanceContextFilter() {
        assertThat("в БК отправлено правильное поле FILTER.OnlyOfferRetargeting", filter.getOnlyOfferRetargeting()
                , equalTo(onlyOfferRetargeting));
    }
}
