package ru.yandex.autotests.directintapi.bstransport.main.performance.context.filter;

import org.hamcrest.Matcher;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsPerformanceRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Filter;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 18.01.16.
 * https://st.yandex-team.ru/TESTIRT-8254
 * https://st.yandex-team.ru/TESTIRT-10194
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Features({FeatureNames.SMART_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-50174")
@Description("Проверка зависимости отправки фильтра в UpdateData2 от значений " +
        "ppc.bids_performance.is_deleted и ppc.bids_performance.is_suspended")
@RunWith(Parameterized.class)
public class CheckInfuenceOfIsDeletedAndIsSuspendedToSendingUpdateDataTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    @ClassRule
    public static DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static Context context;
    private static BidsPerformanceRecord bidsPerformance;
    private static int shard;
    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter(0)
    public int isDeleted;

    @Parameterized.Parameter(1)
    public int isSuspended;

    @Parameterized.Parameter(2)
    public Matcher matcher;

    @Parameterized.Parameters(name = "is_deleted = {0}, is_suspended = {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {0, 0, notNullValue()},
                {0, 1, nullValue()},
                {1, 0, nullValue()},
                {1, 1, nullValue()},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        bidsPerformance =
                api.userSteps.getDirectJooqDbSteps().useShard(shard)
                        .bidsPerformanceSteps().getBidsPerformanceByPid(bannersRule.getGroupId()).get(0);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, bannersRule.getCampaignId());
    }

    @Before
    public void before() {
        bidsPerformance.setIsDeleted(isDeleted);
        bidsPerformance.setIsSuspended(isSuspended);
        bidsPerformance.setStatusbssynced(BidsPerformanceStatusbssynced.No);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsPerformanceSteps().updateBidsPerformance(bidsPerformance);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupsSteps().setPhrasesStatusBsSynced(bannersRule.getGroupId(), PhrasesStatusbssynced.No);
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard,
                bannersRule.getCampaignId());
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        context = campaign != null ? campaign.getContext(bannersRule.getGroupId()) : null;
        assumeThat("в БК отправился CONTEXT", context, notNullValue());
    }


    @Test
    public void checkFilterInUpdateData2() {
        Filter filter = context.getFilter(bidsPerformance.getPerfFilterId().intValue());
        assertThat("правильность наличия или отсутствия фильтра", filter, matcher);
    }
}
