package ru.yandex.autotests.directintapi.bstransport.main.performance.context.performancetgocoef;

import java.util.Map;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.core.Is.is;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ProductTypeCoef.PERFORMANCE_TGO;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра ProductTypeCoef.PerformanceTgo на уровне группы, удаление")
@Stories(StoriesNames.GROUP_PARAMS_PERFORMANCETGOCOEF)
@Features({FeatureNames.GROUPS})
@Issue("https://st.yandex-team.ru/DIRECT-73028")
public class BsTransportOfPerformanceContextPerformanceTgoPriceCoefDeleteTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final Short PERFORMANCE_TGO_COEF = 1200;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);

    @Rule
    public Trashman trashman = new Trashman(api);

    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private int shard;
    private long cid;
    private long pid;

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        cid = bannersRule.getCampaignId();
        pid = bannersRule.getGroupId();

        api.userSteps.getDirectJooqDbSteps().useShard(shard).multipliersSteps()
                .saveGroupPerformanceTgoMultiplier(cid, pid, PERFORMANCE_TGO_COEF);
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в БК отправлена группа", context, notNullValue());
        assumeThat("на уровне группы есть поле ProductTypeCoef", context.getProductTypeCoef(), notNullValue());
        assumeThat("на уровне группы есть поле ProductTypeCoef.PerformanceTgo",
                context.getProductTypeCoef().getPerformanceTgo(), notNullValue());
    }

    @Test
    @Title("Отправка в БК корректировки ProductTypeCoef.PerformanceTgo на уровне группы при ее удалении")
    @SuppressWarnings("unchecked")
    public void testTransportOfGroupPerformanceTgoPriceCoefAfterDelete() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).multipliersSteps().deleteAllMultipliers(cid);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, "No");
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Map<String, Map> contextMap = helpSteps.getContextMap(resp, cid, pid);
        assumeThat("в БК отправлена группа", contextMap, notNullValue());
        assumeThat("на уровне группы есть поле ProductTypeCoef",
                contextMap.containsKey(Context.PRODUCT_TYPE_COEF), is(true));
        Map<String, String> contextPriceCoefMap = (Map<String, String>) contextMap.get(Context.PRODUCT_TYPE_COEF);
        assumeThat("на уровне группы есть поле ProductTypeCoef.PerformanceTgo",
                contextPriceCoefMap.containsKey(PERFORMANCE_TGO), is(true));
        assertThat("поле ProductTypeCoef.PerformanceTgo на уровне группы равно null",
                contextPriceCoefMap.get(PERFORMANCE_TGO), nullValue());
    }
}
