package ru.yandex.autotests.directintapi.bstransport.main.performance.order;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Features(FeatureNames.SMART_BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-54957")
@Title("Отправка AutoBudgetMaxBid для перформансов")
public class BsTransportOfPerformanceAutoBudgetMaxBidTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    // Максимальная цена клика в валюте клиента
    private static float AUTOBUDGET_MAX_BID_CUR = 22.22f;
    // Максимальная цена клика в фишках
    private static float AUTOBUDGET_MAX_BID = 0.873987f;
    private static double DELTA = 0.000001;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);

    @Rule
    public Trashman trashman = new Trashman(api);

    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private Campaign campaign;

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);
        long cid = bannersRule.getCampaignId();
        api.userSteps.getDirectJooqDbSteps().campaignsSteps().setAutobudgetBid(cid, AUTOBUDGET_MAX_BID_CUR);

        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setAutobudgetBid(
                    strategyId, AUTOBUDGET_MAX_BID_CUR);
        }

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard,
                bannersRule.getCampaignId());
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0,
                bannersRule.getCampaignId());
        assumeThat("в БК отправлена кампания", campaign, notNullValue());
    }

    @Test
    public void performanceAutoBudgetMaxBidCur() {
        assertEquals("в БК отправился правильный AutoBudgetMaxBidCur",
                campaign.getAutoBudgetMaxBidCur(), AUTOBUDGET_MAX_BID_CUR, DELTA);
    }

    @Test
    public void performanceAutoBudgetMaxBid() {
        assertEquals("в БК отправился правильный AutoBudgetMaxBid",
                campaign.getAutoBudgetMaxBid(), AUTOBUDGET_MAX_BID, DELTA);
    }
}

