package ru.yandex.autotests.directintapi.bstransport.main.performance.queue.updatedobjects;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 08.10.2015
 * https://st.yandex-team.ru/TESTIRT-7394
 * https://st.yandex-team.ru/TESTIRT-10194
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Features({FeatureNames.SMART_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-44221")
public class BsTransportOfPerformanceUpdatedCampaignToQueueTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    private static int shard;
    @Rule
    public Trashman trashman = new Trashman(api);
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }


    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, shard);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, bannersRule.getCampaignId());
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().updateCampaigns(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampaignById(bannersRule.getCampaignId())
                        .setStatusbssynced(CampaignsStatusbssynced.No)
        );
        api.userSteps.getDarkSideSteps().getTransportSteps()
                .runBsExportMasterScript(shard, bannersRule.getCampaignId());
    }

    @Test
    public void performanceAddedInQueueFields() {
        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(bannersRule.getCampaignId());
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись " +
                        "для новой performance кампании",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withCamps()
                        .withoutBanners()
                        .withoutContexts()
                        .withoutBids()
                        .withoutPrices());
    }
}
