package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.queue;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.steps.ScriptParamsProfiles;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Постановка в очередь новой кампании уже обработанной полным реэкспортом")
@Description("Предусловие: кампания уже добавленна в bs_export_queue скриптом полного реэкспорта. (full_lb_export = 1)")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.FULL_EXPORT, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewCampWithGroupBannerPhrasesAlreadyProcessedByFullLBExportTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Добавление в очередь новой кампании(группа+баннер+фраза), предобработанной bsFullLBExportMater.pl")
    @Description("Проверяем обновление статистики в bs_export_queue")
    public void testAddingToBsQueueForNewPhraseInNewGroup() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        //ставим кампанию в очередь скриптом полного реэкспорта
        api.userSteps.getDarkSideSteps().getBsExportSteps().addCampaignToFullExportQueue(cid);

        //запускаем обычный экспорт
        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);

        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid,
                ScriptParamsProfiles.ProfileNames.DEFAULT);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());

        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, notNullValue());

        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, bid);
        assertThat("Ожидаем, что в БК может быть отправлен баннер", banner, notNullValue());

        Map phrase = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена фраза", phrase, notNullValue());
    }
}
