package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "новой фразы в составе новой группы при отрицательных значениях статуса statusModerate")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class AddingToBsQueueNewPhraseInNewGroupWithNegativeModerationTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Parameterized.Parameter
    public String testStatus;

    @Parameterized.Parameters(name = "Статус модерации фразы statusModerate = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Status.NEW},
                {Status.NO}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Добавление в очередь кампании с не принятой новой фразой в новой группе (кампания так же новая)")
    public void testAddingToBsQueueForNewPhraseInNewGroupDependingOnNegativeModeration() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        Long bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makePhraseActive(keywordId);

        api.userSteps.phrasesFakeSteps().setStatusModerate(bidsId, testStatus);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);

        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());

        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, notNullValue());

        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, bid);
        assertThat("Ожидаем, что в БК может быть отправлен баннер", banner, notNullValue());
    }
}
