package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.receive;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.qatools.Tag;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;

import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "новой фразы в составе новой группы с отклоненными новыми фразами (1)")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewPhraseInNewGroupWithDeclinedPhraseTest1
        extends BsResponseHandlingForNewPhraseInNewGroupWithDeclinedPhraseBaseTest {

    @Test
    @Title("Изменения после успешной отправки кампании с новой фразой в новой группе (кампания так же новая) " +
            "(присутствуют не принятые фразы) - статус statusBsSynced Кампании")
    public void testCampaignSyncStatusAfterTransmissionForNewPhraseInNewGroupWithDeclinedPhrase() {
        CampaignsRecord campaignDb = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid);
        assertThat("после синхронизации кампании statusBsSynced = Yes",
                campaignDb.getStatusbssynced(), equalTo(CampaignsStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новой фразой в новой группе (кампания так же новая) " +
            "(присутствуют не принятые фразы) - статус statusBsSynced Группы")
    public void testGroupSyncStatusAfterTransmissionForNewPhraseInNewGroupWithDeclinedPhrase() {
        PhrasesRecord groupDb = api.userSteps.getDirectJooqDbSteps().adGroupsSteps().getPhrases(pid);
        assertThat("после синхронизации группы statusBsSynced = Yes",
                groupDb.getStatusbssynced(), equalTo(PhrasesStatusbssynced.Yes));
    }
}
