package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.receive;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class BsResponseHandlingForNewPhraseInSyncedGroupWithDeclinedPhraseBaseTest {

    protected static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static int shard;

    protected static Long cid;
    protected static Long pid;
    protected static Long acceptedBidsId;
    protected static Long notAcceptedBidsId;
    protected static Long declinedBidsId;
    protected static Long bid;

    protected static Campaign campaign;
    protected static Phrase acceptedPhrase;
    protected static Banner banner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long syncedPhraseId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(syncedPhraseId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        final int newPhrasesNum = 3;
        List<Long> newKeywordIds = api.userSteps.keywordsSteps().addDefaultKeywords(pid, newPhrasesNum);
        acceptedBidsId = newKeywordIds.get(0);
        notAcceptedBidsId = newKeywordIds.get(1);
        declinedBidsId = newKeywordIds.get(2);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().setStatusModerate(acceptedBidsId, YES);
        api.userSteps.phrasesFakeSteps().setStatusModerate(declinedBidsId, NO);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);


        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        acceptedPhrase = context != null ? context.getPhrase(acceptedBidsId) : null;
        banner = context != null ? context.getBanner(bid) : null;

        assumeThat("в ответе БК присутствует кампания", campaign, notNullValue());
        assumeThat("в ответе БК присутствует контекст", context, notNullValue());
        assumeThat("в ответе БК присутствует фраза", acceptedPhrase, notNullValue());
        assumeThat("в ответе БК присутствует баннер", banner, notNullValue());
    }
}
